/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.javax.annotation.Nullable;

public class Network {
    private final String id;
    private final String account;
    private final String broadcastDomainType;
    private final URI broadcastURI;
    private final String displayText;
    private final String DNS1;
    private final String DNS2;
    private final String domain;
    private final String domainId;
    private final String endIP;
    private final String gateway;
    private final boolean isDefault;
    private final boolean isShared;
    private final boolean isSystem;
    private final String netmask;
    private final String networkDomain;
    private final String networkOfferingAvailability;
    private final String networkOfferingDisplayText;
    private final String networkOfferingId;
    private final String networkOfferingName;
    private final String related;
    private final String startIP;
    private final String name;
    private final String state;
    private final GuestIPType guestIPType;
    private final String VLAN;
    private final TrafficType trafficType;
    private final String zoneId;
    private final Set<String> tags;
    private final boolean securityGroupEnabled;
    private final Set<? extends NetworkService> services;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromNetwork(this);
    }

    @ConstructorProperties(value={"id", "account", "broadcastdomaintype", "broadcasturi", "displaytext", "dns1", "dns2", "domain", "domainid", "endip", "gateway", "isdefault", "isshared", "issystem", "netmask", "networkdomain", "networkofferingavailability", "networkofferingdisplaytext", "networkofferingid", "networkofferingname", "related", "startip", "name", "state", "type", "vlan", "traffictype", "zoneid", "tags", "securitygroupenabled", "service"})
    protected Network(String id, @Nullable String account, @Nullable String broadcastDomainType, @Nullable URI broadcastURI, @Nullable String displayText, @Nullable String DNS1, @Nullable String DNS2, @Nullable String domain, @Nullable String domainId, @Nullable String endIP, @Nullable String gateway, boolean isDefault, boolean isShared, boolean isSystem, @Nullable String netmask, @Nullable String networkDomain, @Nullable String networkOfferingAvailability, @Nullable String networkOfferingDisplayText, @Nullable String networkOfferingId, @Nullable String networkOfferingName, @Nullable String related, @Nullable String startIP, @Nullable String name, @Nullable String state, @Nullable GuestIPType guestIPType, @Nullable String VLAN, @Nullable TrafficType trafficType, @Nullable String zoneId, @Nullable Iterable<String> tags, boolean securityGroupEnabled, Set<? extends NetworkService> services) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.broadcastDomainType = broadcastDomainType;
        this.broadcastURI = broadcastURI;
        this.displayText = displayText;
        this.DNS1 = DNS1;
        this.DNS2 = DNS2;
        this.domain = domain;
        this.domainId = domainId;
        this.endIP = endIP;
        this.gateway = gateway;
        this.isDefault = isDefault;
        this.isShared = isShared;
        this.isSystem = isSystem;
        this.netmask = netmask;
        this.networkDomain = networkDomain;
        this.networkOfferingAvailability = networkOfferingAvailability;
        this.networkOfferingDisplayText = networkOfferingDisplayText;
        this.networkOfferingId = networkOfferingId;
        this.networkOfferingName = networkOfferingName;
        this.related = related;
        this.startIP = startIP;
        this.name = name;
        this.state = state;
        this.guestIPType = guestIPType;
        this.VLAN = VLAN;
        this.trafficType = trafficType;
        this.zoneId = zoneId;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
        this.securityGroupEnabled = securityGroupEnabled;
        this.services = ImmutableSortedSet.copyOf(services);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getBroadcastDomainType() {
        return this.broadcastDomainType;
    }

    @Nullable
    public URI getBroadcastURI() {
        return this.broadcastURI;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add((Object)this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add((Object)this.DNS2);
        }
        return builder.build();
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getEndIP() {
        return this.endIP;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getNetworkDomain() {
        return this.networkDomain;
    }

    @Nullable
    public String getNetworkOfferingAvailability() {
        return this.networkOfferingAvailability;
    }

    @Nullable
    public String getNetworkOfferingDisplayText() {
        return this.networkOfferingDisplayText;
    }

    @Nullable
    public String getNetworkOfferingId() {
        return this.networkOfferingId;
    }

    @Nullable
    public String getNetworkOfferingName() {
        return this.networkOfferingName;
    }

    @Nullable
    public String getRelated() {
        return this.related;
    }

    @Nullable
    public String getStartIP() {
        return this.startIP;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    @Nullable
    public String getVLAN() {
        return this.VLAN;
    }

    @Nullable
    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean isSecurityGroupEnabled() {
        return this.securityGroupEnabled;
    }

    public Set<? extends NetworkService> getServices() {
        return this.services;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.broadcastDomainType, this.broadcastURI, this.displayText, this.DNS1, this.DNS2, this.domain, this.domainId, this.endIP, this.gateway, this.isDefault, this.isShared, this.isSystem, this.netmask, this.networkDomain, this.networkOfferingAvailability, this.networkOfferingDisplayText, this.networkOfferingId, this.networkOfferingName, this.related, this.startIP, this.name, this.state, this.guestIPType, this.VLAN, this.trafficType, this.zoneId, this.tags, this.securityGroupEnabled, this.services});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Network that = (Network)Network.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.broadcastDomainType, (Object)that.broadcastDomainType) && Objects.equal((Object)this.broadcastURI, (Object)that.broadcastURI) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.DNS1, (Object)that.DNS1) && Objects.equal((Object)this.DNS2, (Object)that.DNS2) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.endIP, (Object)that.endIP) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.isDefault, (Object)that.isDefault) && Objects.equal((Object)this.isShared, (Object)that.isShared) && Objects.equal((Object)this.isSystem, (Object)that.isSystem) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.networkDomain, (Object)that.networkDomain) && Objects.equal((Object)this.networkOfferingAvailability, (Object)that.networkOfferingAvailability) && Objects.equal((Object)this.networkOfferingDisplayText, (Object)that.networkOfferingDisplayText) && Objects.equal((Object)this.networkOfferingId, (Object)that.networkOfferingId) && Objects.equal((Object)this.networkOfferingName, (Object)that.networkOfferingName) && Objects.equal((Object)this.related, (Object)that.related) && Objects.equal((Object)this.startIP, (Object)that.startIP) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)((Object)this.guestIPType), (Object)((Object)that.guestIPType)) && Objects.equal((Object)this.VLAN, (Object)that.VLAN) && Objects.equal((Object)((Object)this.trafficType), (Object)((Object)that.trafficType)) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal(this.tags, that.tags) && Objects.equal((Object)this.securityGroupEnabled, (Object)that.securityGroupEnabled) && Objects.equal(this.services, that.services);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("broadcastDomainType", (Object)this.broadcastDomainType).add("broadcastURI", (Object)this.broadcastURI).add("displayText", (Object)this.displayText).add("DNS1", (Object)this.DNS1).add("DNS2", (Object)this.DNS2).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("endIP", (Object)this.endIP).add("gateway", (Object)this.gateway).add("isDefault", this.isDefault).add("isShared", this.isShared).add("isSystem", this.isSystem).add("netmask", (Object)this.netmask).add("networkDomain", (Object)this.networkDomain).add("networkOfferingAvailability", (Object)this.networkOfferingAvailability).add("networkOfferingDisplayText", (Object)this.networkOfferingDisplayText).add("networkOfferingId", (Object)this.networkOfferingId).add("networkOfferingName", (Object)this.networkOfferingName).add("related", (Object)this.related).add("startIP", (Object)this.startIP).add("name", (Object)this.name).add("state", (Object)this.state).add("guestIPType", (Object)this.guestIPType).add("VLAN", (Object)this.VLAN).add("trafficType", (Object)this.trafficType).add("zoneId", (Object)this.zoneId).add("tags", this.tags).add("securityGroupEnabled", this.securityGroupEnabled).add("services", this.services);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected String broadcastDomainType;
        protected URI broadcastURI;
        protected String displayText;
        protected String DNS1;
        protected String DNS2;
        protected String domain;
        protected String domainId;
        protected String endIP;
        protected String gateway;
        protected boolean isDefault;
        protected boolean isShared;
        protected boolean isSystem;
        protected String netmask;
        protected String networkDomain;
        protected String networkOfferingAvailability;
        protected String networkOfferingDisplayText;
        protected String networkOfferingId;
        protected String networkOfferingName;
        protected String related;
        protected String startIP;
        protected String name;
        protected String state;
        protected GuestIPType guestIPType;
        protected String VLAN;
        protected TrafficType trafficType;
        protected String zoneId;
        protected ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        protected boolean securityGroupEnabled;
        protected Set<? extends NetworkService> services = ImmutableSortedSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T broadcastDomainType(String broadcastDomainType) {
            this.broadcastDomainType = broadcastDomainType;
            return this.self();
        }

        public T broadcastURI(URI broadcastURI) {
            this.broadcastURI = broadcastURI;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T DNS(List<String> DNS) {
            if (!DNS.isEmpty()) {
                this.DNS1 = DNS.get(0);
            }
            if (DNS.size() > 1) {
                this.DNS2 = DNS.get(1);
            }
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T endIP(String endIP) {
            this.endIP = endIP;
            return this.self();
        }

        public T gateway(String gateway) {
            this.gateway = gateway;
            return this.self();
        }

        public T isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this.self();
        }

        public T isShared(boolean isShared) {
            this.isShared = isShared;
            return this.self();
        }

        public T isSystem(boolean isSystem) {
            this.isSystem = isSystem;
            return this.self();
        }

        public T netmask(String netmask) {
            this.netmask = netmask;
            return this.self();
        }

        public T networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this.self();
        }

        public T networkOfferingAvailability(String networkOfferingAvailability) {
            this.networkOfferingAvailability = networkOfferingAvailability;
            return this.self();
        }

        public T networkOfferingDisplayText(String networkOfferingDisplayText) {
            this.networkOfferingDisplayText = networkOfferingDisplayText;
            return this.self();
        }

        public T networkOfferingId(String networkOfferingId) {
            this.networkOfferingId = networkOfferingId;
            return this.self();
        }

        public T networkOfferingName(String networkOfferingName) {
            this.networkOfferingName = networkOfferingName;
            return this.self();
        }

        public T related(String related) {
            this.related = related;
            return this.self();
        }

        public T startIP(String startIP) {
            this.startIP = startIP;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this.self();
        }

        public T VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this.self();
        }

        public T trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T tags(Iterable<String> tags) {
            this.tags = ImmutableSet.builder().addAll(tags);
            return this.self();
        }

        public T tag(String tag) {
            this.tags.add((Object)tag);
            return this.self();
        }

        public T securityGroupEnabled(boolean securityGroupEnabled) {
            this.securityGroupEnabled = securityGroupEnabled;
            return this.self();
        }

        public T services(Set<? extends NetworkService> services) {
            this.services = services;
            return this.self();
        }

        public Network build() {
            return new Network(this.id, this.account, this.broadcastDomainType, this.broadcastURI, this.displayText, this.DNS1, this.DNS2, this.domain, this.domainId, this.endIP, this.gateway, this.isDefault, this.isShared, this.isSystem, this.netmask, this.networkDomain, this.networkOfferingAvailability, this.networkOfferingDisplayText, this.networkOfferingId, this.networkOfferingName, this.related, this.startIP, this.name, this.state, this.guestIPType, this.VLAN, this.trafficType, this.zoneId, (Iterable<String>)this.tags.build(), this.securityGroupEnabled, this.services);
        }

        public T fromNetwork(Network in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).broadcastDomainType(in.getBroadcastDomainType())).broadcastURI(in.getBroadcastURI())).displayText(in.getDisplayText())).DNS(in.getDNS())).domain(in.getDomain())).domainId(in.getDomainId())).endIP(in.getEndIP())).gateway(in.getGateway())).isDefault(in.isDefault())).isShared(in.isShared())).isSystem(in.isSystem())).netmask(in.getNetmask())).networkDomain(in.getNetworkDomain())).networkOfferingAvailability(in.getNetworkOfferingAvailability())).networkOfferingDisplayText(in.getNetworkOfferingDisplayText())).networkOfferingId(in.getNetworkOfferingId())).networkOfferingName(in.getNetworkOfferingName())).related(in.getRelated())).startIP(in.getStartIP())).name(in.getName())).state(in.getState())).guestIPType(in.getGuestIPType())).VLAN(in.getVLAN())).trafficType(in.getTrafficType())).zoneId(in.getZoneId())).tags(in.getTags())).securityGroupEnabled(in.isSecurityGroupEnabled())).services(in.getServices());
        }
    }
}

