/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.NATAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.CreateIPForwardingRuleOptions;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NATAsyncClientTest")
public class NATAsyncClientTest
extends BaseCloudStackAsyncClientTest<NATAsyncClient> {
    HttpRequest createIpForwardingRule = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createIpForwardingRule"}).addQueryParam("ipaddressid", new String[]{"7"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("startport", new String[]{"22"}).build();
    HttpRequest createIpForwardingRuleOptions = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createIpForwardingRule"}).addQueryParam("ipaddressid", new String[]{"7"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("startport", new String[]{"22"}).addQueryParam("endport", new String[]{"22"}).build();

    public void testListIPForwardingRules() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("listIPForwardingRules", ListIPForwardingRulesOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listIpForwardingRules&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListIPForwardingRulesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("listIPForwardingRules", ListIPForwardingRulesOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ListIPForwardingRulesOptions.Builder.virtualMachineId((String)"3")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listIpForwardingRules&listAll=true&virtualmachineid=3 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetIPForwardingRule() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("getIPForwardingRule", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{5});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listIpForwardingRules&listAll=true&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateIPForwardingRuleForVirtualMachine() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("createIPForwardingRule", String.class, String.class, Integer.TYPE, CreateIPForwardingRuleOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{7, "tcp", 22});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.createIpForwardingRule.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateIPForwardingRuleForVirtualMachineOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("createIPForwardingRule", String.class, String.class, Integer.TYPE, CreateIPForwardingRuleOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{7, "tcp", 22, CreateIPForwardingRuleOptions.Builder.endPort((int)22)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.createIpForwardingRuleOptions.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testEnableStaticNATForVirtualMachine() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("enableStaticNATForVirtualMachine", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{5, 6});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=enableStaticNat&virtualmachineid=5&ipaddressid=6 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDisableStaticNATOnPublicIP() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("disableStaticNATOnPublicIP", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{5});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=disableStaticNat&ipaddressid=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteIPForwardingRule() throws SecurityException, NoSuchMethodException, IOException {
        Method method = NATAsyncClient.class.getMethod("deleteIPForwardingRule", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{5});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteIpForwardingRule&id=5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<NATAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<NATAsyncClient>>(){};
    }
}

