/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateAccountOptions;
import org.jclouds.cloudstack.options.UpdateAccountOptions;
import org.jclouds.crypto.CryptoStreams;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalAccountClientLiveTest")
public class GlobalAccountClientLiveTest
extends BaseCloudStackClientLiveTest {
    public static Account createTestAccount(CloudStackGlobalClient client, String prefix) {
        return client.getAccountClient().createAccount(prefix + "-account", Account.Type.USER, "dummy@example.com", "First", "Last", CryptoStreams.md5Hex((String)"password"), new CreateAccountOptions[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndRemoveAccount() {
        this.skipIfNotGlobalAdmin();
        Account account = null;
        try {
            account = GlobalAccountClientLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
            Assert.assertNotNull((Object)account);
            Assert.assertEquals((String)account.getName(), (String)(this.prefix + "-account"));
            Assert.assertEquals((Object)account.getType(), (Object)Account.Type.USER);
            Account updated = this.globalAdminClient.getAccountClient().updateAccount(account.getName(), account.getDomainId(), this.prefix + "-account-2", new UpdateAccountOptions[0]);
            Assert.assertNotNull((Object)updated);
            Assert.assertEquals((String)updated.getName(), (String)(this.prefix + "-account-2"));
        }
        finally {
            if (account != null) {
                this.globalAdminClient.getAccountClient().deleteAccount(account.getId());
            }
        }
    }
}

