/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.features.GlobalAccountAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.CreateAccountOptions;
import org.jclouds.cloudstack.options.UpdateAccountOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalAccountAsyncClientTest")
public class GlobalAccountAsyncClientTest
extends BaseCloudStackAsyncClientTest<GlobalAccountAsyncClient> {
    HttpRequest create = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createAccount"}).addQueryParam("username", new String[]{"user"}).addQueryParam("accounttype", new String[]{"0"}).addQueryParam("email", new String[]{"email@example.com"}).addQueryParam("firstname", new String[]{"FirstName"}).addQueryParam("lastname", new String[]{"LastName"}).addQueryParam("password", new String[]{"hashed-password"}).build();
    HttpRequest update = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"updateAccount"}).addQueryParam("account", new String[]{"account"}).addQueryParam("domainid", new String[]{"42"}).addQueryParam("newname", new String[]{"new-account-name"}).build();

    public void testCreateAccount() throws Exception {
        Method method = GlobalAccountAsyncClient.class.getMethod("createAccount", String.class, Account.Type.class, String.class, String.class, String.class, String.class, CreateAccountOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"user", Account.Type.USER, "email@example.com", "FirstName", "LastName", "hashed-password"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.create.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateAccount() throws Exception {
        Method method = GlobalAccountAsyncClient.class.getMethod("updateAccount", String.class, String.class, String.class, UpdateAccountOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"account", 42L, "new-account-name"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.update.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteAccount() throws Exception {
        Method method = GlobalAccountAsyncClient.class.getMethod("deleteAccount", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{42L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteAccount&id=42 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<GlobalAccountAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GlobalAccountAsyncClient>>(){};
    }
}

