/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.domain.ResourceLimit;
import org.jclouds.cloudstack.features.DomainLimitAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DomainLimitAsyncClientTest")
public class DomainLimitAsyncClientTest
extends BaseCloudStackAsyncClientTest<DomainLimitAsyncClient> {
    public void testUpdateResourceLimit() throws SecurityException, NoSuchMethodException, IOException {
        Method method = DomainLimitAsyncClient.class.getMethod("updateResourceLimit", ResourceLimit.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ResourceLimit.builder().resourceType(ResourceLimit.ResourceType.SNAPSHOT).account("foo").domainId("100").max(101).build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateResourceLimit&resourcetype=3&account=foo&domainid=100&max=101 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<DomainLimitAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<DomainLimitAsyncClient>>(){};
    }
}

