/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Maps;

@Test(groups={"unit"}, testName="CloudStackTemplateOptionsTest")
public class CloudStackTemplateOptionsTest {
    @Test
    public void testAs() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Object)options.as(CloudStackTemplateOptions.class), (Object)options);
    }

    @Test
    public void testDefaultSecurityGroupIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of());
    }

    @Test
    public void testSecurityGroupId() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().securityGroupId("3");
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testSecurityGroupIdStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.securityGroupId((String)"3");
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testSecurityGroupIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().securityGroupIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testSecurityGroupIdsStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.securityGroupIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getSecurityGroupIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testDefaultNetworkIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworkIds(), (Set)ImmutableSet.of());
    }

    @Test
    public void testNetworkId() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().networkId("3");
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworkIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testNetworkIdStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.networkId((String)"3");
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworkIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testNetworkIds() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().networkIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworkIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testNetworkIdsStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.networkIds((Iterable)ImmutableSet.of((Object)"3"));
        Assert.assertEquals((Set)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getNetworkIds(), (Set)ImmutableSet.of((Object)"3"));
    }

    @Test
    public void testIpOnDefaultNetwork() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().ipOnDefaultNetwork("10.0.0.1");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpOnDefaultNetwork(), (String)"10.0.0.1");
    }

    @Test
    public void testIpOnDefaultNetworkStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.ipOnDefaultNetwork((String)"10.0.0.1");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpOnDefaultNetwork(), (String)"10.0.0.1");
    }

    @Test
    public void testIpsToNetwork() {
        Map ipsToNetworks = Maps.newHashMap();
        ipsToNetworks.put("10.0.0.1", "5");
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().ipsToNetworks(ipsToNetworks);
        Assert.assertEquals((String)((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpsToNetworks().get("10.0.0.1")), (String)"5");
    }

    @Test
    public void testIpsToNetworkStatic() {
        Map ipsToNetworks = Maps.newHashMap();
        ipsToNetworks.put("10.0.0.1", "5");
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.ipsToNetworks((Map)ipsToNetworks);
        Assert.assertEquals((String)((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getIpsToNetworks().get("10.0.0.1")), (String)"5");
    }

    @Test
    public void testSetupStaticNatDefaultsTrue() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        Assert.assertTrue((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testSetupStaticNat() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions().setupStaticNat(false);
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testSetupStaticNatStatic() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.setupStaticNat((boolean)false);
        Assert.assertFalse((boolean)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).shouldSetupStaticNat());
    }

    @Test
    public void testKeyPair() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.keyPair((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getKeyPair(), (String)"test");
    }

    @Test
    public void testAccount() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.account((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getAccount(), (String)"test");
    }

    @Test
    public void testDomainId() {
        CloudStackTemplateOptions options = CloudStackTemplateOptions.Builder.domainId((String)"test");
        Assert.assertEquals((String)((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).getDomainId(), (String)"test");
    }

    @Test
    public void testSecurityGroupIdsNullHasDecentMessage() {
        try {
            new CloudStackTemplateOptions().securityGroupIds(null);
            assert (false) : "should NPE";
        }
        catch (NullPointerException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"securityGroupIds was null");
        }
    }
}

