/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import java.util.Map;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.internal.BaseCloudStackComputeServiceContextExpectTest;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CloudStackComputeServiceAdapterExpectTest
extends BaseCloudStackComputeServiceContextExpectTest<Injector> {
    HttpResponse deployVMResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deployvirtualmachineresponse.json"))).build();
    HttpRequest queryAsyncJobResult = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"50006"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"v8BWKMxd%2BIzHIuTaZ9sNSzCWqFI%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpResponse queryAsyncJobResultResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-virtualmachine.json"))).build();

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPair() {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"hI/U4cWXdU6KTZKbJvzPCmOpGmU%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").setupStaticNat(false);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)server.getCredentials(), (Object)LoginCredentials.builder().password("dD7jwajkh").build());
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithKeyPairAssignedToAccountAndDomain() {
        HttpRequest deployVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deployVirtualMachine"}).addQueryParam("zoneid", new String[]{"1"}).addQueryParam("serviceofferingid", new String[]{"1"}).addQueryParam("templateid", new String[]{"4"}).addQueryParam("displayname", new String[]{"test-e92"}).addQueryParam("name", new String[]{"test-e92"}).addQueryParam("account", new String[]{"account"}).addQueryParam("domainid", new String[]{"domainId"}).addQueryParam("networkids", new String[]{"204"}).addQueryParam("keypair", new String[]{"mykeypair"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"ly5Pip8ICOoVTmNLdDBTc3gbKlA%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)deployVM, (Object)this.deployVMResponse).put((Object)this.queryAsyncJobResult, (Object)this.queryAsyncJobResultResponse).build();
        Injector forKeyPair = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forKeyPair.getInstance(TemplateBuilder.class)).osFamily(OsFamily.CENTOS).build();
        ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair("mykeypair").account("account").domainId("domainId").setupStaticNat(false);
        CloudStackComputeServiceAdapter adapter = (CloudStackComputeServiceAdapter)forKeyPair.getInstance(CloudStackComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)server.getCredentials(), (Object)LoginCredentials.builder().password("dD7jwajkh").build());
    }

    @Override
    protected Injector clientFrom(CloudStackContext context) {
        return context.utils().injector();
    }
}

