/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;

public class NetworkPredicates {
    public static Predicate<NetworkService> supportsStaticNAT = Predicates.and((Predicate)new NetworkServiceNamed("Firewall"), (Predicate)new CapabilitiesInclude("StaticNat"));
    public static Predicate<NetworkService> supportsPortForwarding = Predicates.and((Predicate)new NetworkServiceNamed("Firewall"), (Predicate)new CapabilitiesInclude("PortForwarding"));
    public static Predicate<NetworkService> isLoadBalancerService = new NetworkServiceNamed("Lb");
    public static Predicate<GuestIPType> isVirtualNetwork = new GuestIPTypeIs(GuestIPType.VIRTUAL);
    public static Predicate<GuestIPType> isIsolatedNetwork = new GuestIPTypeIs(GuestIPType.ISOLATED);
    public static Predicate<GuestIPType> isSharedNetwork = new GuestIPTypeIs(GuestIPType.SHARED);

    public static Predicate<Network> supportsStaticNAT() {
        return HasFirewallServiceWhichSupportsStaticNAT.INSTANCE;
    }

    public static Predicate<Network> supportsPortForwarding() {
        return HasFirewallServiceWhichSupportsPortForwarding.INSTANCE;
    }

    public static Predicate<Network> hasLoadBalancerService() {
        return HasLoadBalancerService.INSTANCE;
    }

    public static Predicate<Network> isVirtualNetwork() {
        return IsVirtualNetwork.INSTANCE;
    }

    public static Predicate<Network> isIsolatedNetwork() {
        return IsIsolatedNetwork.INSTANCE;
    }

    public static Predicate<Network> isSharedNetwork() {
        return IsSharedNetwork.INSTANCE;
    }

    public static Predicate<Network> defaultNetworkInZone(String zoneId) {
        return new DefaultNetworkInZone(zoneId);
    }

    public static Predicate<Network> any() {
        return Predicates.alwaysTrue();
    }

    public static class CapabilitiesInclude
    implements Predicate<NetworkService> {
        private final String capability;

        public CapabilitiesInclude(String capability) {
            this.capability = (String)Preconditions.checkNotNull((Object)capability, (Object)"capability");
        }

        public boolean apply(NetworkService input) {
            return "true".equals(input.getCapabilities().get(this.capability));
        }

        public String toString() {
            return "capabilitiesInclude(" + this.capability + ")";
        }
    }

    public static class GuestIPTypeIs
    implements Predicate<GuestIPType> {
        private final GuestIPType guestIPType;

        public GuestIPTypeIs(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
        }

        public boolean apply(@Nullable GuestIPType guestIPType) {
            return guestIPType == this.guestIPType;
        }

        public String toString() {
            return "guestIPTypeIs(" + (Object)((Object)this.guestIPType) + ')';
        }
    }

    public static class NetworkServiceNamed
    implements Predicate<NetworkService> {
        private final String name;

        public NetworkServiceNamed(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        public boolean apply(NetworkService input) {
            return this.name.equals(((NetworkService)Preconditions.checkNotNull((Object)input, (Object)"networkService")).getName());
        }

        public String toString() {
            return "networkServiceNamed(" + this.name + ")";
        }
    }

    private static class DefaultNetworkInZone
    implements Predicate<Network> {
        private final String zoneId;

        public DefaultNetworkInZone(String zoneId) {
            this.zoneId = zoneId;
        }

        public boolean apply(Network network) {
            return network.getZoneId().equals(this.zoneId) && network.isDefault();
        }
    }

    public static enum IsIsolatedNetwork implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            boolean network = isIsolatedNetwork.apply((Object)((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getGuestIPType());
            return network;
        }

        public String toString() {
            return isIsolatedNetwork.toString();
        }
    }

    public static enum IsSharedNetwork implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            boolean network = isSharedNetwork.apply((Object)((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getGuestIPType());
            return network;
        }

        public String toString() {
            return isSharedNetwork.toString();
        }
    }

    public static enum IsVirtualNetwork implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            boolean network = isVirtualNetwork.apply((Object)((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getGuestIPType());
            return network;
        }

        public String toString() {
            return isVirtualNetwork.toString();
        }
    }

    public static enum HasLoadBalancerService implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            return Iterables.any(((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getServices(), isLoadBalancerService);
        }

        public String toString() {
            return isLoadBalancerService.toString();
        }
    }

    public static enum HasFirewallServiceWhichSupportsPortForwarding implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            return Iterables.any(((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getServices(), supportsPortForwarding);
        }

        public String toString() {
            return supportsPortForwarding.toString();
        }
    }

    public static enum HasFirewallServiceWhichSupportsStaticNAT implements Predicate<Network>
    {
        INSTANCE;


        public boolean apply(Network arg0) {
            return Iterables.any(((Network)Preconditions.checkNotNull((Object)arg0, (Object)"network")).getServices(), supportsStaticNAT);
        }

        public String toString() {
            return supportsStaticNAT.toString();
        }
    }
}

