/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.TemplateFilter;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListTemplatesOptions
extends AccountInDomainOptions {
    public static final ListTemplatesOptions NONE = new ListTemplatesOptions();

    public ListTemplatesOptions() {
        this.filter(TemplateFilter.EXECUTABLE);
    }

    public ListTemplatesOptions filter(TemplateFilter filter) {
        this.queryParameters.replaceValues((Object)"templatefilter", (Iterable)ImmutableSet.of((Object)filter.toString()));
        return this;
    }

    public ListTemplatesOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)(id + "")));
        return this;
    }

    public ListTemplatesOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public ListTemplatesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues((Object)"zoneid", (Iterable)ImmutableSet.of((Object)(zoneId + "")));
        return this;
    }

    public ListTemplatesOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues((Object)"hypervisor", (Iterable)ImmutableSet.of((Object)hypervisor));
        return this;
    }

    @Override
    public ListTemplatesOptions accountInDomain(String account, String domain) {
        return (ListTemplatesOptions)((Object)ListTemplatesOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListTemplatesOptions domainId(String domainId) {
        return (ListTemplatesOptions)((Object)ListTemplatesOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static ListTemplatesOptions filter(TemplateFilter filter) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.filter(filter);
        }

        public static ListTemplatesOptions domainId(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.domainId(id);
        }

        public static ListTemplatesOptions accountInDomain(String account, String domain) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListTemplatesOptions id(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.id(id);
        }

        public static ListTemplatesOptions name(String name) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.name(name);
        }

        public static ListTemplatesOptions zoneId(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.zoneId(id);
        }

        public static ListTemplatesOptions hypervisor(String hypervisor) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.hypervisor(hypervisor);
        }
    }
}

