/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.javax.annotation.Nullable;

public class TemplateExtraction
implements Comparable<TemplateExtraction> {
    private final String id;
    private final String accountId;
    private final Date created;
    private final String extractId;
    private final ExtractMode extractMode;
    private final String name;
    private final String state;
    private final String status;
    private final String storageType;
    private final int uploadPercentage;
    private final String url;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTemplateExtraction(this);
    }

    @ConstructorProperties(value={"id", "accountid", "created", "extractId", "extractMode", "name", "state", "status", "storagetype", "uploadpercentage", "url", "zoneid", "zonename"})
    protected TemplateExtraction(String id, @Nullable String accountId, @Nullable Date created, @Nullable String extractId, @Nullable ExtractMode extractMode, @Nullable String name, @Nullable String state, @Nullable String status, @Nullable String storageType, int uploadPercentage, @Nullable String url, @Nullable String zoneId, @Nullable String zoneName) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.accountId = accountId;
        this.created = created;
        this.extractId = extractId;
        this.extractMode = extractMode;
        this.name = name;
        this.state = state;
        this.status = status;
        this.storageType = storageType;
        this.uploadPercentage = uploadPercentage;
        this.url = url;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getExtractId() {
        return this.extractId;
    }

    @Nullable
    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Nullable
    public String getStorageType() {
        return this.storageType;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateExtraction that = (TemplateExtraction)TemplateExtraction.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.extractId, (Object)that.extractId) && Objects.equal((Object)((Object)this.extractMode), (Object)((Object)that.extractMode)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.storageType, (Object)that.storageType) && Objects.equal((Object)this.uploadPercentage, (Object)that.uploadPercentage) && Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("accountId", (Object)this.accountId).add("created", (Object)this.created).add("extractId", (Object)this.extractId).add("extractMode", (Object)this.extractMode).add("name", (Object)this.name).add("state", (Object)this.state).add("status", (Object)this.status).add("storageType", (Object)this.storageType).add("uploadPercentage", this.uploadPercentage).add("url", (Object)this.url).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(TemplateExtraction other) {
        return this.id.compareTo(other.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String accountId;
        protected Date created;
        protected String extractId;
        protected ExtractMode extractMode;
        protected String name;
        protected String state;
        protected String status;
        protected String storageType;
        protected int uploadPercentage;
        protected String url;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T extractId(String extractId) {
            this.extractId = extractId;
            return this.self();
        }

        public T extractMode(ExtractMode extractMode) {
            this.extractMode = extractMode;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T status(String status) {
            this.status = status;
            return this.self();
        }

        public T storageType(String storageType) {
            this.storageType = storageType;
            return this.self();
        }

        public T uploadPercentage(int uploadPercentage) {
            this.uploadPercentage = uploadPercentage;
            return this.self();
        }

        public T url(String url) {
            this.url = url;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public TemplateExtraction build() {
            return new TemplateExtraction(this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName);
        }

        public T fromTemplateExtraction(TemplateExtraction in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).accountId(in.getAccountId())).created(in.getCreated())).extractId(in.getExtractId())).extractMode(in.getExtractMode())).name(in.getName())).state(in.getState())).status(in.getStatus())).storageType(in.getStorageType())).uploadPercentage(in.getUploadPercentage())).url(in.getUrl())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }
}

