/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NetworkOfferingAvailabilityType;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.javax.annotation.Nullable;

public class NetworkOffering
implements Comparable<NetworkOffering> {
    private final String id;
    private final String name;
    private final String displayText;
    private final Date created;
    private final NetworkOfferingAvailabilityType availability;
    private final Integer maxConnections;
    private final boolean isDefault;
    private final boolean supportsVLAN;
    private final TrafficType trafficType;
    private final GuestIPType guestIPType;
    private final int networkRate;
    private final String tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromNetworkOffering(this);
    }

    @ConstructorProperties(value={"id", "name", "displaytext", "created", "availability", "maxconnections", "isdefault", "specifyvlan", "traffictype", "guestiptype", "networkrate", "tags"})
    protected NetworkOffering(String id, @Nullable String name, @Nullable String displayText, @Nullable Date created, @Nullable NetworkOfferingAvailabilityType availability, @Nullable Integer maxConnections, boolean isDefault, boolean supportsVLAN, @Nullable TrafficType trafficType, @Nullable GuestIPType guestIPType, int networkRate, @Nullable String tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.availability = availability;
        this.maxConnections = maxConnections;
        this.isDefault = isDefault;
        this.supportsVLAN = supportsVLAN;
        this.trafficType = trafficType;
        this.guestIPType = guestIPType;
        this.networkRate = networkRate;
        this.tags = tags;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public NetworkOfferingAvailabilityType getAvailability() {
        return this.availability;
    }

    @Nullable
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean supportsVLAN() {
        return this.supportsVLAN;
    }

    @Nullable
    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    @Nullable
    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public int getNetworkRate() {
        return this.networkRate;
    }

    @Nullable
    public String getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.displayText, this.created, this.availability, this.maxConnections, this.isDefault, this.supportsVLAN, this.trafficType, this.guestIPType, this.networkRate, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkOffering that = (NetworkOffering)NetworkOffering.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)((Object)this.availability), (Object)((Object)that.availability)) && Objects.equal((Object)this.maxConnections, (Object)that.maxConnections) && Objects.equal((Object)this.isDefault, (Object)that.isDefault) && Objects.equal((Object)this.supportsVLAN, (Object)that.supportsVLAN) && Objects.equal((Object)((Object)this.trafficType), (Object)((Object)that.trafficType)) && Objects.equal((Object)((Object)this.guestIPType), (Object)((Object)that.guestIPType)) && Objects.equal((Object)this.networkRate, (Object)that.networkRate) && Objects.equal((Object)this.tags, (Object)that.tags);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("displayText", (Object)this.displayText).add("created", (Object)this.created).add("availability", (Object)this.availability).add("maxConnections", (Object)this.maxConnections).add("isDefault", this.isDefault).add("supportsVLAN", this.supportsVLAN).add("trafficType", (Object)this.trafficType).add("guestIPType", (Object)this.guestIPType).add("networkRate", this.networkRate).add("tags", (Object)this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(NetworkOffering o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String displayText;
        protected Date created;
        protected NetworkOfferingAvailabilityType availability;
        protected Integer maxConnections;
        protected boolean isDefault;
        protected boolean supportsVLAN;
        protected TrafficType trafficType;
        protected GuestIPType guestIPType;
        protected int networkRate;
        protected String tags;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T availability(NetworkOfferingAvailabilityType availability) {
            this.availability = availability;
            return this.self();
        }

        public T maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this.self();
        }

        public T isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this.self();
        }

        public T supportsVLAN(boolean supportsVLAN) {
            this.supportsVLAN = supportsVLAN;
            return this.self();
        }

        public T trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this.self();
        }

        public T guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this.self();
        }

        public T networkRate(int networkRate) {
            this.networkRate = networkRate;
            return this.self();
        }

        public T tags(String tags) {
            this.tags = tags;
            return this.self();
        }

        public NetworkOffering build() {
            return new NetworkOffering(this.id, this.name, this.displayText, this.created, this.availability, this.maxConnections, this.isDefault, this.supportsVLAN, this.trafficType, this.guestIPType, this.networkRate, this.tags);
        }

        public T fromNetworkOffering(NetworkOffering in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).displayText(in.getDisplayText())).created(in.getCreated())).availability(in.getAvailability())).maxConnections(in.getMaxConnections())).isDefault(in.isDefault())).supportsVLAN(in.supportsVLAN())).trafficType(in.getTrafficType())).guestIPType(in.getGuestIPType())).networkRate(in.getNetworkRate())).tags(in.getTags());
        }
    }
}

