/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class DiskOffering
implements Comparable<DiskOffering> {
    private final String id;
    private final String name;
    private final String displayText;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final int diskSize;
    private final boolean customized;
    private final String tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDiskOffering(this);
    }

    @ConstructorProperties(value={"id", "name", "displaytext", "created", "domain", "domainid", "disksize", "iscustomized", "tags"})
    protected DiskOffering(String id, @Nullable String name, @Nullable String displayText, @Nullable Date created, @Nullable String domain, @Nullable String domainId, int diskSize, boolean customized, @Nullable String tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.diskSize = diskSize;
        this.customized = customized;
        this.tags = tags;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    @Nullable
    public String getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiskOffering that = (DiskOffering)DiskOffering.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.diskSize, (Object)that.diskSize) && Objects.equal((Object)this.customized, (Object)that.customized) && Objects.equal((Object)this.tags, (Object)that.tags);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("displayText", (Object)this.displayText).add("created", (Object)this.created).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("diskSize", this.diskSize).add("customized", this.customized).add("tags", (Object)this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(DiskOffering other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String displayText;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected int diskSize;
        protected boolean customized;
        protected String tags;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T diskSize(int diskSize) {
            this.diskSize = diskSize;
            return this.self();
        }

        public T customized(boolean customized) {
            this.customized = customized;
            return this.self();
        }

        public T tags(String tags) {
            this.tags = tags;
            return this.self();
        }

        public DiskOffering build() {
            return new DiskOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags);
        }

        public T fromDiskOffering(DiskOffering in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).displayText(in.getDisplayText())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).diskSize(in.getDiskSize())).customized(in.isCustomized())).tags(in.getTags());
        }
    }
}

