/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudstack.config.CloudStackDateAdapter;
import org.jclouds.cloudstack.domain.UsageRecord;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListUsageRecordsResponseTest
extends BaseSetParserTest<UsageRecord> {
    public String resource() {
        return "/listusagerecordsresponse.json";
    }

    @SelectJson(value="usagerecord")
    public Set<UsageRecord> expected() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.set(1, 2011);
        c.set(2, 11);
        c.set(5, 15);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date start = c.getTime();
        c.add(5, 1);
        c.add(13, -1);
        Date end = c.getTime();
        return ImmutableSet.of((Object)UsageRecord.builder().accountName("admin").accountId("2").domainId("1").zoneId("1").description("Template Id:203 Size:3117171712").usage("24 Hrs").usageType(UsageRecord.UsageType.TEMPLATE).rawUsageHours(24.0).templateId("0").id("203").startDate(start).endDate(end).build());
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new GsonModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(CloudStackDateAdapter.class);
                super.configure();
            }
        }});
    }
}

