/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.parse;

import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudstack.domain.StoragePool;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListStoragePoolsResponseTest
extends BaseItemParserTest<Set<StoragePool>> {
    public String resource() {
        return "/liststoragepoolsresponse.json";
    }

    @SelectJson(value="storagepool")
    public Set<StoragePool> expected() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT+02:00"));
        c.set(1, 2011);
        c.set(2, 10);
        c.set(5, 26);
        c.set(11, 23);
        c.set(12, 33);
        c.set(13, 6);
        Date created = c.getTime();
        StoragePool storagePool = StoragePool.builder().id("201").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").name("NFS Pri 1").ipAddress("10.26.26.165").path("/mnt/nfs/cs_pri").created(created).type(StoragePool.Type.NETWORK_FILESYSTEM).clusterId("1").clusterName("Xen Clust 1").diskSizeTotal(898356445184L).diskSizeAllocated(18276679680L).tags("").state(StoragePool.State.UP).build();
        return ImmutableSet.of((Object)storagePool);
    }
}

