/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Set;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAccountsResponseTest
extends BaseSetParserTest<Account> {
    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new GsonModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
                super.configure();
            }
        }});
    }

    public String resource() {
        return "/listaccountsresponse.json";
    }

    @SelectJson(value="account")
    public Set<Account> expected() {
        return ImmutableSet.of((Object)Account.builder().id("505").name("jclouds").type(Account.Type.USER).domainId("457").domain("AA000062-jclouds-dev").receivedBytes(318900216L).sentBytes(23189677L).VMLimit(Long.valueOf(15L)).VMs(1L).IPsAvailable(Long.valueOf(14L)).IPLimit(Long.valueOf(15L)).IPs(0L).IPsAvailable(Long.valueOf(15L)).volumeLimit(Long.valueOf(90L)).volumes(2L).volumesAvailable(Long.valueOf(88L)).snapshotLimit(Long.valueOf(250L)).snapshots(0L).snapshotsAvailable(Long.valueOf(250L)).templateLimit(Long.valueOf(15L)).templates(0L).templatesAvailable(Long.valueOf(15L)).VMsAvailable(Long.valueOf(14L)).VMsStopped(0L).VMsRunning(1L).state(Account.State.ENABLED).users((Set)ImmutableSet.of((Object)User.builder().id("505").name("jclouds").firstName("Adrian").lastName("Cole").email("adrian@jclouds.org").created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-04-19T01:57:24+0000")).state(User.State.ENABLED).account("jclouds").accountType(Account.Type.USER).domainId("457").domain("AA000062-jclouds-dev").apiKey("APIKEY").secretKey("SECRETKEY").build())).build());
    }
}

