/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.GlobalAccountClientLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateUserOptions;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.cloudstack.options.UpdateUserOptions;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalUserClientLiveTest")
public class GlobalUserClientLiveTest
extends BaseCloudStackClientLiveTest {
    public static User createTestUser(CloudStackGlobalClient client, Account account, String prefix) {
        return client.getUserClient().createUser(prefix + "-user", account.getName(), "dummy2@example.com", CryptoStreams.md5Hex((String)"password"), "First", "Last", new CreateUserOptions[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUser() {
        this.skipIfNotGlobalAdmin();
        Account testAccount = GlobalAccountClientLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
        User testUser = null;
        try {
            testUser = GlobalUserClientLiveTest.createTestUser(this.globalAdminClient, testAccount, this.prefix);
            Assert.assertNotNull((Object)testUser);
            Assert.assertEquals((String)testUser.getName(), (String)(this.prefix + "-user"));
            Assert.assertEquals((String)testUser.getAccount(), (String)(this.prefix + "-account"));
            User updatedUser = this.globalAdminClient.getUserClient().updateUser(testUser.getId(), new UpdateUserOptions[]{UpdateUserOptions.Builder.userName((String)(this.prefix + "-user-2"))});
            Assert.assertNotNull((Object)updatedUser);
            Assert.assertEquals((String)updatedUser.getName(), (String)(this.prefix + "-user-2"));
            ApiKeyPair apiKeys = this.globalAdminClient.getUserClient().registerUserKeys(updatedUser.getId());
            Assert.assertNotNull((Object)apiKeys.getApiKey());
            Assert.assertNotNull((Object)apiKeys.getSecretKey());
            this.checkAuthAsUser(apiKeys);
        }
        finally {
            if (testUser != null) {
                this.globalAdminClient.getUserClient().deleteUser(testUser.getId());
            }
            this.globalAdminClient.getAccountClient().deleteAccount(testAccount.getId());
        }
    }

    private void checkAuthAsUser(ApiKeyPair keyPair) {
        ComputeServiceContext context = (ComputeServiceContext)this.createView(this.credentialsAsProperties(keyPair), this.setupModules());
        CloudStackClient client = (CloudStackClient)((RestContext)context.unwrap(CloudStackApiMetadata.CONTEXT_TOKEN)).getApi();
        Set accounts = client.getAccountClient().listAccounts(new ListAccountsOptions[0]);
        assert (accounts.size() > 0);
        context.close();
    }

    private Properties credentialsAsProperties(ApiKeyPair keyPair) {
        Properties overrides = this.setupProperties();
        overrides.put(this.provider + ".identity", Preconditions.checkNotNull((Object)keyPair.getApiKey()));
        overrides.put(this.provider + ".credential", Preconditions.checkNotNull((Object)keyPair.getSecretKey()));
        return overrides;
    }
}

