/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.ConfigurationEntry;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListConfigurationEntriesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Sets;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalConfigurationClientLiveTest")
public class GlobalConfigurationClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test
    public void testListConfigurationEntries() {
        this.skipIfNotGlobalAdmin();
        Set entries = this.globalAdminClient.getConfigurationClient().listConfigurationEntries(new ListConfigurationEntriesOptions[0]);
        Set categories = Sets.newHashSet();
        for (ConfigurationEntry entry : entries) {
            this.checkConfigurationEntry(entry);
            categories.add(entry.getCategory());
        }
        assert (categories.containsAll((Collection<?>)ImmutableSet.of((Object)"Network", (Object)"Advanced", (Object)"Premium", (Object)"Storage", (Object)"Usage", (Object)"Snapshots", (Object[])new Object[]{"Account Defaults", "Console Proxy", "Alert"})));
    }

    @Test
    public void testUpdateConfigurationEntry() {
        this.skipIfNotGlobalAdmin();
        Set entries = this.globalAdminClient.getConfigurationClient().listConfigurationEntries(new ListConfigurationEntriesOptions[0]);
        long expungeDelay = Long.parseLong(this.getValueByName(entries, "expunge.delay"));
        assert (expungeDelay > 0L);
        this.globalAdminClient.getConfigurationClient().updateConfigurationEntry("expunge.delay", "" + (expungeDelay + 1L));
        long newDelay = Long.parseLong(((ConfigurationEntry)Iterables.getOnlyElement((Iterable)this.globalAdminClient.getConfigurationClient().listConfigurationEntries(new ListConfigurationEntriesOptions[]{ListConfigurationEntriesOptions.Builder.name((String)"expunge.delay")}))).getValue());
        Assert.assertEquals((long)newDelay, (long)(expungeDelay + 1L));
        this.globalAdminClient.getConfigurationClient().updateConfigurationEntry("expunge.delay", "" + expungeDelay);
    }

    private void checkConfigurationEntry(ConfigurationEntry entry) {
        Assert.assertEquals((Object)entry, (Object)this.getEntryByName(this.globalAdminClient.getConfigurationClient().listConfigurationEntries(new ListConfigurationEntriesOptions[]{ListConfigurationEntriesOptions.Builder.name((String)entry.getName())}), entry.getName()));
        assert (entry.getCategory() != null) : entry;
        assert (entry.getDescription() != null) : entry;
        assert (entry.getName() != null) : entry;
    }

    private String getValueByName(Set<ConfigurationEntry> entries, String name) {
        return this.getEntryByName(entries, name).getValue();
    }

    private ConfigurationEntry getEntryByName(Set<ConfigurationEntry> entries, final String name) {
        return (ConfigurationEntry)Iterables.find(entries, (Predicate)new Predicate<ConfigurationEntry>(){

            public boolean apply(@Nullable ConfigurationEntry entry) {
                return entry != null && Objects.equal((Object)name, (Object)entry.getName());
            }
        });
    }
}

