/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;

@Singleton
public class RetryOnRenewAndLogoutOnClose
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final LoadingCache<Credentials, LoginResponse> authenticationResponseCache;
    private final SessionClient sessionClient;

    @Inject
    protected RetryOnRenewAndLogoutOnClose(LoadingCache<Credentials, LoginResponse> authenticationResponseCache, SessionClient sessionClient) {
        this.authenticationResponseCache = authenticationResponseCache;
        this.sessionClient = sessionClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            switch (response.getStatusCode()) {
                case 401: {
                    byte[] content = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                    if (!new String(content).equals("TODO: What state can we retry?")) break;
                    this.logger.debug("invalidating session", new Object[0]);
                    this.authenticationResponseCache.invalidateAll();
                    retry = true;
                }
            }
            boolean bl = retry;
            return bl;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }

    @PreDestroy
    public void logoutOnClose() {
        for (LoginResponse s : this.authenticationResponseCache.asMap().values()) {
            try {
                this.sessionClient.logoutUser(s.getSessionKey());
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "error logging out session %s", new Object[]{s.getSessionKey()});
            }
        }
    }
}

