/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

public class ParseLoginResponseFromHttpResponse
implements Function<HttpResponse, LoginResponse> {
    private ParseFirstJsonValueNamed<LoginResponse> parser;

    @Inject
    ParseLoginResponseFromHttpResponse(GsonWrapper gson) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gson, (Object)"gsonWrapper"), (TypeLiteral)new TypeLiteral<LoginResponse>(){}, "loginresponse");
    }

    public LoginResponse apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        LoginResponse login = (LoginResponse)this.parser.apply(response);
        Preconditions.checkNotNull((Object)login, (Object)"loginResponse");
        String jSessionId = (String)Iterables.get((Iterable)Splitter.on((String)"=").split((CharSequence)Iterables.get((Iterable)Splitter.on((String)";").trimResults().split((CharSequence)Iterables.getOnlyElement((Iterable)response.getHeaders().get((Object)"Set-Cookie"))), (int)0)), (int)1);
        return LoginResponse.builder().copyOf(login).jSessionId(jSessionId).build();
    }
}

