/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;

@Singleton
public class AddSessionKeyAndJSessionIdToRequest
implements AuthenticationFilter {
    private final Supplier<LoginResponse> loginResponseSupplier;
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public AddSessionKeyAndJSessionIdToRequest(Supplier<LoginResponse> loginResponseSupplier, Provider<UriBuilder> uriBuilderProvider) {
        this.loginResponseSupplier = loginResponseSupplier;
        this.uriBuilderProvider = uriBuilderProvider;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        LoginResponse loginResponse = (LoginResponse)this.loginResponseSupplier.get();
        request = ModifyRequest.replaceHeader((HttpRequest)request, (String)"Cookie", (String[])new String[]{"JSESSIONID=" + loginResponse.getJSessionId()});
        request = ModifyRequest.addQueryParam((HttpRequest)request, (String)"sessionkey", (Object)loginResponse.getSessionKey(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        return request;
    }
}

