/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class VlanIPRange
implements Comparable<VlanIPRange> {
    private long id;
    private String description;
    @SerializedName(value="forvirtualnetwork")
    private boolean forVirtualNetwork;
    @SerializedName(value="zoneid")
    private long zoneId;
    private String vlan;
    private String account;
    @SerializedName(value="domainid")
    private long domainId;
    private String domain;
    @SerializedName(value="podid")
    private long podId;
    @SerializedName(value="podname")
    private String podName;
    private String gateway;
    private String netmask;
    @SerializedName(value="startip")
    private String startIP;
    @SerializedName(value="endip")
    private String endIP;
    @SerializedName(value="networkid")
    private long networkId;

    public static Builder builder() {
        return new Builder();
    }

    VlanIPRange() {
    }

    public VlanIPRange(long id, String description, boolean forVirtualNetwork, long zoneId, String vlan, String account, long domainId, String domain, long podId, String podName, String gateway, String netmask, String startIP, String endIP, long networkId) {
        this.id = id;
        this.description = description;
        this.forVirtualNetwork = forVirtualNetwork;
        this.zoneId = zoneId;
        this.vlan = vlan;
        this.account = account;
        this.domainId = domainId;
        this.domain = domain;
        this.podId = podId;
        this.podName = podName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIP = startIP;
        this.endIP = endIP;
        this.networkId = networkId;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForVirtualNetwork() {
        return this.forVirtualNetwork;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getVlan() {
        return this.vlan;
    }

    public String getAccount() {
        return this.account;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getStartIP() {
        return this.startIP;
    }

    public String getEndIP() {
        return this.endIP;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VlanIPRange that = (VlanIPRange)o;
        if (this.domainId != that.domainId) {
            return false;
        }
        if (this.forVirtualNetwork != that.forVirtualNetwork) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.networkId != that.networkId) {
            return false;
        }
        if (this.podId != that.podId) {
            return false;
        }
        if (this.zoneId != that.zoneId) {
            return false;
        }
        if (this.account != null ? !this.account.equals(that.account) : that.account != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.endIP != null ? !this.endIP.equals(that.endIP) : that.endIP != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(that.gateway) : that.gateway != null) {
            return false;
        }
        if (this.netmask != null ? !this.netmask.equals(that.netmask) : that.netmask != null) {
            return false;
        }
        if (this.podName != null ? !this.podName.equals(that.podName) : that.podName != null) {
            return false;
        }
        if (this.startIP != null ? !this.startIP.equals(that.startIP) : that.startIP != null) {
            return false;
        }
        return !(this.vlan != null ? !this.vlan.equals(that.vlan) : that.vlan != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.forVirtualNetwork ? 1 : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.vlan != null ? this.vlan.hashCode() : 0);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (int)(this.podId ^ this.podId >>> 32);
        result = 31 * result + (this.podName != null ? this.podName.hashCode() : 0);
        result = 31 * result + (this.gateway != null ? this.gateway.hashCode() : 0);
        result = 31 * result + (this.netmask != null ? this.netmask.hashCode() : 0);
        result = 31 * result + (this.startIP != null ? this.startIP.hashCode() : 0);
        result = 31 * result + (this.endIP != null ? this.endIP.hashCode() : 0);
        result = 31 * result + (int)(this.networkId ^ this.networkId >>> 32);
        return result;
    }

    public String toString() {
        return "VlanIPRange{id=" + this.id + ", description='" + this.description + '\'' + ", forVirtualNetwork=" + this.forVirtualNetwork + ", zoneId=" + this.zoneId + ", vlan='" + this.vlan + '\'' + ", account='" + this.account + '\'' + ", domainId=" + this.domainId + ", domain='" + this.domain + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", gateway='" + this.gateway + '\'' + ", netmask='" + this.netmask + '\'' + ", startIP='" + this.startIP + '\'' + ", endIP='" + this.endIP + '\'' + ", networkId=" + this.networkId + '}';
    }

    @Override
    public int compareTo(VlanIPRange other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private String description;
        private boolean forVirtualNetwork;
        private long zoneId;
        private String vlan;
        private String account;
        private long domainId;
        private String domain;
        private long podId;
        private String podName;
        private String gateway;
        private String netmask;
        private String startIP;
        private String endIP;
        private long networkId;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder forVirtualNetwork(boolean forVirtualNetwork) {
            this.forVirtualNetwork = forVirtualNetwork;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder vlan(long vlan) {
            this.vlan = vlan + "";
            return this;
        }

        public Builder vlan(String vlan) {
            this.vlan = vlan;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder podId(long podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder startIP(String startIP) {
            this.startIP = startIP;
            return this;
        }

        public Builder endIP(String endIP) {
            this.endIP = endIP;
            return this;
        }

        public Builder networkId(long networkId) {
            this.networkId = networkId;
            return this;
        }

        public VlanIPRange build() {
            return new VlanIPRange(this.id, this.description, this.forVirtualNetwork, this.zoneId, this.vlan, this.account, this.domainId, this.domain, this.podId, this.podName, this.gateway, this.netmask, this.startIP, this.endIP, this.networkId);
        }
    }
}

