/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class VMGroup
implements Comparable<VMGroup> {
    private long id;
    private String account;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    private String name;

    public static Builder builder() {
        return new Builder();
    }

    public VMGroup(long id, String account, Date created, String domain, long domainId, String name) {
        this.id = id;
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
    }

    VMGroup() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VMGroup vmGroup = (VMGroup)o;
        if (this.domainId != vmGroup.domainId) {
            return false;
        }
        if (this.id != vmGroup.id) {
            return false;
        }
        if (this.account != null ? !this.account.equals(vmGroup.account) : vmGroup.account != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(vmGroup.created) : vmGroup.created != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(vmGroup.domain) : vmGroup.domain != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(vmGroup.name) : vmGroup.name != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VMGroup{id=" + this.id + ", account='" + this.account + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int compareTo(VMGroup vmGroup) {
        return new Long(this.id).compareTo(vmGroup.getId());
    }

    public static class Builder {
        private long id;
        private String account;
        private Date created;
        private String domain;
        private long domainId;
        private String name;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public VMGroup build() {
            return new VMGroup(this.id, this.account, this.created, this.domain, this.domainId, this.name);
        }
    }
}

