/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class TemplatePermission
implements Comparable<TemplatePermission> {
    private long id;
    private String account;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="ispublic")
    private boolean isPublic;

    public static Builder builder() {
        return new Builder();
    }

    public TemplatePermission(long id, String account, long domainId, boolean isPublic) {
        this.id = id;
        this.account = account;
        this.domainId = domainId;
        this.isPublic = isPublic;
    }

    TemplatePermission() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatePermission that = (TemplatePermission)o;
        if (this.domainId != that.domainId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.isPublic != that.isPublic) {
            return false;
        }
        return !(this.account != null ? !this.account.equals(that.account) : that.account != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.isPublic ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TemplatePermission{id=" + this.id + ", account='" + this.account + '\'' + ", domainId=" + this.domainId + ", isPublic=" + this.isPublic + '}';
    }

    @Override
    public int compareTo(TemplatePermission other) {
        return new Long(this.id).compareTo(other.getId());
    }

    public static class Builder {
        private long id;
        private String account;
        private long domainId;
        private boolean isPublic;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public TemplatePermission build() {
            return new TemplatePermission(this.id, this.account, this.domainId, this.isPublic);
        }
    }
}

