/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;

public class TemplateMetadata {
    private String name;
    private long osTypeId;
    private String displayText;
    private Long snapshotId;
    private Long volumeId;
    private Long virtualMachineId;
    private Boolean passwordEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public TemplateMetadata(String name, long osTypeId, String displayText) {
        this.name = name;
        this.osTypeId = osTypeId;
        this.displayText = displayText;
    }

    TemplateMetadata() {
    }

    public Long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Long getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(Long volumeId) {
        this.volumeId = volumeId;
    }

    public Long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public void setVirtualMachineId(Long virtualMachineId) {
        this.virtualMachineId = virtualMachineId;
    }

    public Boolean getPasswordEnabled() {
        return this.passwordEnabled;
    }

    public void setPasswordEnabled(Boolean passwordEnabled) {
        this.passwordEnabled = passwordEnabled;
    }

    public String getName() {
        return this.name;
    }

    public long getOsTypeId() {
        return this.osTypeId;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateMetadata that = (TemplateMetadata)o;
        if (!Objects.equal((Object)this.osTypeId, (Object)that.osTypeId)) {
            return false;
        }
        if (!Objects.equal((Object)this.snapshotId, (Object)that.snapshotId)) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeId, (Object)that.volumeId)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        if (!Objects.equal((Object)this.passwordEnabled, (Object)that.passwordEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.displayText, this.osTypeId, this.snapshotId, this.volumeId, this.passwordEnabled, this.virtualMachineId});
    }

    public String toString() {
        return "TemplateMetadata{name='" + this.name + '\'' + ", osTypeId=" + this.osTypeId + ", displayText='" + this.displayText + '\'' + ", snapshotId=" + this.snapshotId + ", volumeId=" + this.volumeId + ", virtualMachineId=" + this.virtualMachineId + ", passwordEnabled=" + this.passwordEnabled + '}';
    }

    public static class Builder {
        private String name;
        private long osTypeId;
        private String displayText;
        private Long snapshotId;
        private Long volumeId;
        private Long virtualMachineId;
        private Boolean passwordEnabled;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder osTypeId(long osTypeId) {
            this.osTypeId = osTypeId;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder snapshotId(Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder volumeId(Long volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder virtualMachineId(Long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder passwordEnabled() {
            this.passwordEnabled = true;
            return this;
        }

        public TemplateMetadata build() {
            TemplateMetadata template = new TemplateMetadata(this.name, this.osTypeId, this.displayText);
            template.setPasswordEnabled(this.passwordEnabled);
            template.setSnapshotId(this.snapshotId);
            template.setVirtualMachineId(this.virtualMachineId);
            template.setVolumeId(this.volumeId);
            return template;
        }
    }
}

