/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class SshKeyPair
implements Comparable<SshKeyPair> {
    private String fingerprint;
    private String name;
    @SerializedName(value="privatekey")
    private String privateKey;

    public static Builder builder() {
        return new Builder();
    }

    SshKeyPair() {
    }

    public SshKeyPair(String fingerprint, String name, String privateKey) {
        this.fingerprint = fingerprint;
        this.name = name;
        this.privateKey = privateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getName() {
        return this.name;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fingerprint == null ? 0 : this.fingerprint.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SshKeyPair other = (SshKeyPair)obj;
        if (this.fingerprint == null ? other.fingerprint != null : !this.fingerprint.equals(other.fingerprint)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey));
    }

    public String toString() {
        return "SshKeyPair{fingerprint='" + this.fingerprint + '\'' + ", name='" + this.name + '\'' + ", privateKey='" + this.privateKey + '\'' + '}';
    }

    @Override
    public int compareTo(SshKeyPair arg0) {
        return this.fingerprint.compareTo(arg0.getFingerprint());
    }

    public static class Builder {
        private String fingerprint;
        private String name;
        private String privateKey;

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public SshKeyPair build() {
            return new SshKeyPair(this.fingerprint, this.name, this.privateKey);
        }
    }
}

