/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.AllocationState;

public class Pod
implements Comparable<Pod> {
    private long id;
    private String name;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    private String gateway;
    private String netmask;
    @SerializedName(value="startip")
    private String startIp;
    @SerializedName(value="endip")
    private String endIp;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;

    public static Builder builder() {
        return new Builder();
    }

    Pod() {
    }

    public Pod(long id, String name, long zoneId, String zoneName, String gateway, String netmask, String startIp, String endIp, AllocationState allocationState) {
        this.id = id;
        this.name = name;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIp = startIp;
        this.endIp = endIp;
        this.allocationState = allocationState;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public String getEndIp() {
        return this.endIp;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pod pod = (Pod)o;
        if (this.id != pod.id) {
            return false;
        }
        if (this.zoneId != pod.zoneId) {
            return false;
        }
        if (this.allocationState != pod.allocationState) {
            return false;
        }
        if (this.endIp != null ? !this.endIp.equals(pod.endIp) : pod.endIp != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(pod.gateway) : pod.gateway != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(pod.name) : pod.name != null) {
            return false;
        }
        if (this.netmask != null ? !this.netmask.equals(pod.netmask) : pod.netmask != null) {
            return false;
        }
        if (this.startIp != null ? !this.startIp.equals(pod.startIp) : pod.startIp != null) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(pod.zoneName) : pod.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        result = 31 * result + (this.gateway != null ? this.gateway.hashCode() : 0);
        result = 31 * result + (this.netmask != null ? this.netmask.hashCode() : 0);
        result = 31 * result + (this.startIp != null ? this.startIp.hashCode() : 0);
        result = 31 * result + (this.endIp != null ? this.endIp.hashCode() : 0);
        result = 31 * result + (this.allocationState != null ? this.allocationState.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pod{id=" + this.id + ", name='" + this.name + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", gateway='" + this.gateway + '\'' + ", netmask='" + this.netmask + '\'' + ", startIp='" + this.startIp + '\'' + ", endIp='" + this.endIp + '\'' + ", allocationState=" + (Object)((Object)this.allocationState) + '}';
    }

    @Override
    public int compareTo(Pod other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private String name;
        private long zoneId;
        private String zoneName;
        private String gateway;
        private String netmask;
        private String startIp;
        private String endIp;
        private AllocationState allocationState;

        private Builder() {
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder startIp(String startIp) {
            this.startIp = startIp;
            return this;
        }

        public Builder endIp(String endIp) {
            this.endIp = endIp;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Pod build() {
            return new Pod(this.id, this.name, this.zoneId, this.zoneName, this.gateway, this.netmask, this.startIp, this.endIp, this.allocationState);
        }
    }
}

