/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.domain.TrafficType;

public class Network
implements Comparable<Network> {
    private long id;
    private String account;
    @SerializedName(value="broadcastdomaintype")
    private String broadcastDomainType;
    @SerializedName(value="broadcasturi")
    private URI broadcastURI;
    @SerializedName(value="displaytext")
    private String displayText;
    @SerializedName(value="dns1")
    private String DNS1;
    @SerializedName(value="dns2")
    private String DNS2;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="endip")
    private String endIP;
    private String gateway;
    @SerializedName(value="isdefault")
    private boolean isDefault;
    @SerializedName(value="isshared")
    private boolean isShared;
    @SerializedName(value="issystem")
    private boolean isSystem;
    private String netmask;
    @Nullable
    @SerializedName(value="networkdomain")
    private String networkDomain;
    @SerializedName(value="networkofferingavailability")
    private String networkOfferingAvailability;
    @SerializedName(value="networkofferingdisplaytext")
    private String networkOfferingDisplayText;
    @SerializedName(value="networkofferingid")
    private long networkOfferingId;
    @SerializedName(value="networkofferingname")
    private String networkOfferingName;
    private long related;
    @SerializedName(value="startip")
    private String startIP;
    private String name;
    private String state;
    @SerializedName(value="type")
    private GuestIPType guestIPType;
    @SerializedName(value="vlan")
    private String VLAN;
    @SerializedName(value="traffictype")
    private TrafficType trafficType;
    @SerializedName(value="zoneid")
    private long zoneId;
    private String tags;
    @SerializedName(value="securitygroupenabled")
    private boolean securityGroupEnabled;
    @SerializedName(value="service")
    private SortedSet<? extends NetworkService> services = ImmutableSortedSet.of();

    public static Builder builder() {
        return new Builder();
    }

    Network() {
    }

    public Network(long id, String broadcastDomainType, URI broadcastURI, String displayText, List<String> DNS, String domain, long domainId, String endIP, String gateway, boolean isDefault, boolean isShared, boolean isSystem, String netmask, String networkDomain, String networkOfferingAvailability, String networkOfferingDisplayText, long networkOfferingId, String networkOfferingName, long related, String startIP, String name, String state, GuestIPType type, String vLAN, TrafficType trafficType, long zoneId, Set<? extends NetworkService> services, Set<String> tags, boolean securityGroupEnabled, String account) {
        this.id = id;
        this.broadcastDomainType = broadcastDomainType;
        this.broadcastURI = broadcastURI;
        this.displayText = displayText;
        this.DNS1 = ((List)Preconditions.checkNotNull(DNS, (Object)"DNS")).size() > 0 ? DNS.get(0) : null;
        this.DNS2 = DNS.size() > 1 ? DNS.get(1) : null;
        this.domain = domain;
        this.domainId = domainId;
        this.endIP = endIP;
        this.gateway = gateway;
        this.isDefault = isDefault;
        this.isShared = isShared;
        this.isSystem = isSystem;
        this.netmask = netmask;
        this.networkDomain = networkDomain;
        this.networkOfferingAvailability = networkOfferingAvailability;
        this.networkOfferingDisplayText = networkOfferingDisplayText;
        this.networkOfferingId = networkOfferingId;
        this.networkOfferingName = networkOfferingName;
        this.related = related;
        this.startIP = startIP;
        this.name = name;
        this.state = state;
        this.guestIPType = type;
        this.VLAN = vLAN;
        this.trafficType = trafficType;
        this.zoneId = zoneId;
        this.services = ImmutableSortedSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(services, (Object)"services")));
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
        this.securityGroupEnabled = securityGroupEnabled;
        this.account = account;
    }

    public long getId() {
        return this.id;
    }

    public String getBroadcastDomainType() {
        return this.broadcastDomainType;
    }

    public URI getBroadcastURI() {
        return this.broadcastURI;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add((Object)this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add((Object)this.DNS2);
        }
        return builder.build();
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getAccount() {
        return this.account;
    }

    public String getEndIP() {
        return this.endIP;
    }

    public String getGateway() {
        return this.gateway;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public String getName() {
        return this.name;
    }

    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public String getState() {
        return this.state;
    }

    public String getVLAN() {
        return this.VLAN;
    }

    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getNetworkDomain() {
        return this.networkDomain;
    }

    public String getNetworkOfferingAvailability() {
        return this.networkOfferingAvailability;
    }

    public String getNetworkOfferingDisplayText() {
        return this.networkOfferingDisplayText;
    }

    public long getNetworkOfferingId() {
        return this.networkOfferingId;
    }

    public String getNetworkOfferingName() {
        return this.networkOfferingName;
    }

    public long getRelated() {
        return this.related;
    }

    public String getStartIP() {
        return this.startIP;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public Set<? extends NetworkService> getServices() {
        return this.services;
    }

    public boolean isSecurityGroupEnabled() {
        return this.securityGroupEnabled;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.DNS1 == null ? 0 : this.DNS1.hashCode());
        result = 31 * result + (this.DNS2 == null ? 0 : this.DNS2.hashCode());
        result = 31 * result + (this.VLAN == null ? 0 : this.VLAN.hashCode());
        result = 31 * result + (this.broadcastDomainType == null ? 0 : this.broadcastDomainType.hashCode());
        result = 31 * result + (this.broadcastURI == null ? 0 : this.broadcastURI.hashCode());
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.endIP == null ? 0 : this.endIP.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.guestIPType == null ? 0 : this.guestIPType.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.isShared ? 1231 : 1237);
        result = 31 * result + (this.isSystem ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + (this.networkDomain == null ? 0 : this.networkDomain.hashCode());
        result = 31 * result + (this.networkOfferingAvailability == null ? 0 : this.networkOfferingAvailability.hashCode());
        result = 31 * result + (this.networkOfferingDisplayText == null ? 0 : this.networkOfferingDisplayText.hashCode());
        result = 31 * result + (int)(this.networkOfferingId ^ this.networkOfferingId >>> 32);
        result = 31 * result + (this.networkOfferingName == null ? 0 : this.networkOfferingName.hashCode());
        result = 31 * result + (int)(this.related ^ this.related >>> 32);
        result = 31 * result + (this.services == null ? 0 : this.services.hashCode());
        result = 31 * result + (this.startIP == null ? 0 : this.startIP.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.trafficType == null ? 0 : this.trafficType.hashCode());
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Network other = (Network)obj;
        if (this.DNS1 == null ? other.DNS1 != null : !this.DNS1.equals(other.DNS1)) {
            return false;
        }
        if (this.DNS2 == null ? other.DNS2 != null : !this.DNS2.equals(other.DNS2)) {
            return false;
        }
        if (this.VLAN == null ? other.VLAN != null : !this.VLAN.equals(other.VLAN)) {
            return false;
        }
        if (this.broadcastDomainType == null ? other.broadcastDomainType != null : !this.broadcastDomainType.equals(other.broadcastDomainType)) {
            return false;
        }
        if (this.broadcastURI == null ? other.broadcastURI != null : !this.broadcastURI.equals(other.broadcastURI)) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.endIP == null ? other.endIP != null : !this.endIP.equals(other.endIP)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.guestIPType != other.guestIPType) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        if (this.isShared != other.isShared) {
            return false;
        }
        if (this.isSystem != other.isSystem) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask)) {
            return false;
        }
        if (this.networkDomain == null ? other.networkDomain != null : !this.networkDomain.equals(other.networkDomain)) {
            return false;
        }
        if (this.networkOfferingAvailability == null ? other.networkOfferingAvailability != null : !this.networkOfferingAvailability.equals(other.networkOfferingAvailability)) {
            return false;
        }
        if (this.networkOfferingDisplayText == null ? other.networkOfferingDisplayText != null : !this.networkOfferingDisplayText.equals(other.networkOfferingDisplayText)) {
            return false;
        }
        if (this.networkOfferingId != other.networkOfferingId) {
            return false;
        }
        if (this.networkOfferingName == null ? other.networkOfferingName != null : !this.networkOfferingName.equals(other.networkOfferingName)) {
            return false;
        }
        if (this.related != other.related) {
            return false;
        }
        if (this.services == null ? other.services != null : !this.services.equals(other.services)) {
            return false;
        }
        if (this.startIP == null ? other.startIP != null : !this.startIP.equals(other.startIP)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.trafficType != other.trafficType) {
            return false;
        }
        if (this.zoneId != other.zoneId) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return this.domainId == other.domainId;
    }

    public String toString() {
        return "Network{id=" + this.id + ", account='" + this.account + '\'' + ", broadcastDomainType='" + this.broadcastDomainType + '\'' + ", broadcastURI=" + this.broadcastURI + ", displayText='" + this.displayText + '\'' + ", DNS1='" + this.DNS1 + '\'' + ", DNS2='" + this.DNS2 + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", endIP='" + this.endIP + '\'' + ", gateway='" + this.gateway + '\'' + ", isDefault=" + this.isDefault + ", isShared=" + this.isShared + ", isSystem=" + this.isSystem + ", netmask='" + this.netmask + '\'' + ", networkDomain='" + this.networkDomain + '\'' + ", networkOfferingAvailability='" + this.networkOfferingAvailability + '\'' + ", networkOfferingDisplayText='" + this.networkOfferingDisplayText + '\'' + ", networkOfferingId=" + this.networkOfferingId + ", networkOfferingName='" + this.networkOfferingName + '\'' + ", related=" + this.related + ", startIP='" + this.startIP + '\'' + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", guestIPType=" + (Object)((Object)this.guestIPType) + ", VLAN='" + this.VLAN + '\'' + ", trafficType=" + (Object)((Object)this.trafficType) + ", zoneId=" + this.zoneId + ", tags='" + this.tags + '\'' + ", securityGroupEnabled=" + this.securityGroupEnabled + ", services=" + this.services + '}';
    }

    @Override
    public int compareTo(Network arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private String broadcastDomainType;
        private URI broadcastURI;
        private String displayText;
        private List<String> DNS = ImmutableList.of();
        private String domain;
        private String endIP;
        private String gateway;
        private boolean isDefault;
        private boolean isShared;
        private boolean isSystem;
        private String netmask;
        private String networkDomain;
        private String networkOfferingAvailability;
        private String networkOfferingDisplayText;
        private long networkOfferingId;
        private String networkOfferingName;
        private long related;
        private String startIP;
        private String name;
        private String state;
        private GuestIPType guestIPType;
        private String VLAN;
        private TrafficType trafficType;
        private long zoneId;
        private Set<? extends NetworkService> services = ImmutableSet.of();
        private String account;
        private long domainId;
        private boolean securityGroupEnabled;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder broadcastDomainType(String broadcastDomainType) {
            this.broadcastDomainType = broadcastDomainType;
            return this;
        }

        public Builder broadcastURI(URI broadcastURI) {
            this.broadcastURI = broadcastURI;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder DNS(List<String> DNS) {
            this.DNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(DNS, (Object)"DNS")));
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder endIP(String endIP) {
            this.endIP = endIP;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder isShared(boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder isSystem(boolean isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder networkOfferingAvailability(String networkOfferingAvailability) {
            this.networkOfferingAvailability = networkOfferingAvailability;
            return this;
        }

        public Builder networkOfferingDisplayText(String networkOfferingDisplayText) {
            this.networkOfferingDisplayText = networkOfferingDisplayText;
            return this;
        }

        public Builder networkOfferingId(long networkOfferingId) {
            this.networkOfferingId = networkOfferingId;
            return this;
        }

        public Builder networkOfferingName(String networkOfferingName) {
            this.networkOfferingName = networkOfferingName;
            return this;
        }

        public Builder related(long related) {
            this.related = related;
            return this;
        }

        public Builder startIP(String startIP) {
            this.startIP = startIP;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this;
        }

        public Builder VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this;
        }

        public Builder trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder services(Set<? extends NetworkService> services) {
            this.services = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(services, (Object)"services")));
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder securityGroupEnabled(boolean securityGroupEnabled) {
            this.securityGroupEnabled = securityGroupEnabled;
            return this;
        }

        public Network build() {
            return new Network(this.id, this.broadcastDomainType, this.broadcastURI, this.displayText, this.DNS, this.domain, this.domainId, this.endIP, this.gateway, this.isDefault, this.isShared, this.isSystem, this.netmask, this.networkDomain, this.networkOfferingAvailability, this.networkOfferingDisplayText, this.networkOfferingId, this.networkOfferingName, this.related, this.startIP, this.name, this.state, this.guestIPType, this.VLAN, this.trafficType, this.zoneId, this.services, this.tags, this.securityGroupEnabled, this.account);
        }
    }
}

