/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class LoadBalancerRule
implements Comparable<LoadBalancerRule> {
    private long id;
    private String account;
    private Algorithm algorithm;
    private String description;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    private String name;
    @SerializedName(value="privateport")
    private int privatePort;
    @SerializedName(value="publicip")
    private String publicIP;
    @SerializedName(value="publicipid")
    private long publicIPId;
    @SerializedName(value="publicport")
    private int publicPort;
    private State state;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="zoneId")
    private long zoneId;

    public static Builder builder() {
        return new Builder();
    }

    LoadBalancerRule() {
    }

    public LoadBalancerRule(long id, String account, Algorithm algorithm, String description, String domain, long domainId, String name, int privatePort, String publicIP, long publicIPId, int publicPort, State state, long zoneId, Set<String> CIDRs) {
        this.id = id;
        this.account = account;
        this.algorithm = algorithm;
        this.description = description;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
        this.privatePort = privatePort;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.publicPort = publicPort;
        this.state = state;
        this.zoneId = zoneId;
        this.CIDRs = ImmutableSet.copyOf(CIDRs);
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getName() {
        return this.name;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public long getPublicIPId() {
        return this.publicIPId;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public State getState() {
        return this.state;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    @Override
    public int compareTo(LoadBalancerRule arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.privatePort;
        result = 31 * result + (this.publicIP == null ? 0 : this.publicIP.hashCode());
        result = 31 * result + (int)(this.publicIPId ^ this.publicIPId >>> 32);
        result = 31 * result + this.publicPort;
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerRule other = (LoadBalancerRule)obj;
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals((Object)other.algorithm)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.zoneId != other.zoneId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privatePort != other.privatePort) {
            return false;
        }
        if (this.publicIP == null ? other.publicIP != null : !this.publicIP.equals(other.publicIP)) {
            return false;
        }
        if (this.publicIPId != other.publicIPId) {
            return false;
        }
        if (this.publicPort != other.publicPort) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals((Object)other.state));
    }

    public String toString() {
        return "LoadBalancerRule{id=" + this.id + ", account='" + this.account + '\'' + ", algorithm=" + (Object)((Object)this.algorithm) + ", description='" + this.description + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", name='" + this.name + '\'' + ", privatePort=" + this.privatePort + ", publicIP='" + this.publicIP + '\'' + ", publicIPId=" + this.publicIPId + ", publicPort=" + this.publicPort + ", state=" + (Object)((Object)this.state) + ", CIDRs=" + this.CIDRs + ", zoneId=" + this.zoneId + '}';
    }

    public static class Builder {
        private long id;
        private String account;
        private Algorithm algorithm;
        private String description;
        private String domain;
        private long domainId;
        private String name;
        private int privatePort;
        private String publicIP;
        private long publicIPId;
        private int publicPort;
        private State state;
        private Set<String> CIDRs = ImmutableSet.of();
        private long zoneId;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this;
        }

        public Builder publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this;
        }

        public Builder publicIPId(long publicIPId) {
            this.publicIPId = publicIPId;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public LoadBalancerRule build() {
            return new LoadBalancerRule(this.id, this.account, this.algorithm, this.description, this.domain, this.domainId, this.name, this.privatePort, this.publicIP, this.publicIPId, this.publicPort, this.state, this.zoneId, this.CIDRs);
        }
    }

    public static enum Algorithm {
        SOURCE,
        ROUNDROBIN,
        LEASTCONN,
        UNRECOGNIZED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Algorithm fromValue(String algorithm) {
            try {
                return Algorithm.valueOf(((String)Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        ADD,
        ACTIVE,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

