/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Set;

public class IPForwardingRule
implements Comparable<IPForwardingRule> {
    private long id;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="ipaddressid")
    private long IPAddressId;
    @SerializedName(value="startport")
    private int startPort;
    private String protocol;
    @SerializedName(value="endport")
    public int endPort;
    private String state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    public long virtualMachineId;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="publicport")
    public int publicPort;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="privateendport")
    private int privateEndPort;
    @SerializedName(value="publicendport")
    private int publicEndPort;

    public static Builder builder() {
        return new Builder();
    }

    IPForwardingRule() {
    }

    public IPForwardingRule(long id, String iPAddress, long iPAddressId, int startPort, String protocol, int endPort, String state, String virtualMachineDisplayName, long virtualMachineId, String virtualMachineName, int publicEndPort, int publicPort, Set<String> CIDRs, int privateEndPort) {
        this.id = id;
        this.IPAddress = iPAddress;
        this.IPAddressId = iPAddressId;
        this.startPort = startPort;
        this.protocol = protocol;
        this.endPort = endPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.CIDRs = Sets.newHashSet(CIDRs);
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
        this.publicPort = publicPort;
    }

    @Override
    public int compareTo(IPForwardingRule arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public long getId() {
        return this.id;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public long getIPAddressId() {
        return this.IPAddressId;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public String getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public Set<String> getCIDRs() {
        return Collections.unmodifiableSet(this.CIDRs);
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.IPAddress == null ? 0 : this.IPAddress.hashCode());
        result = 31 * result + (int)(this.IPAddressId ^ this.IPAddressId >>> 32);
        result = 31 * result + this.endPort;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + this.startPort;
        result = 31 * result + this.publicEndPort;
        result = 31 * result + this.privateEndPort;
        result = 31 * result + this.publicPort;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.virtualMachineDisplayName == null ? 0 : this.virtualMachineDisplayName.hashCode());
        result = 31 * result + (int)(this.virtualMachineId ^ this.virtualMachineId >>> 32);
        result = 31 * result + (this.virtualMachineName == null ? 0 : this.virtualMachineName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPForwardingRule other = (IPForwardingRule)obj;
        if (this.IPAddress == null ? other.IPAddress != null : !this.IPAddress.equals(other.IPAddress)) {
            return false;
        }
        if (this.IPAddressId != other.IPAddressId) {
            return false;
        }
        if (this.endPort != other.endPort) {
            return false;
        }
        if (this.publicPort != other.publicPort) {
            return false;
        }
        if (this.publicEndPort != other.publicEndPort) {
            return false;
        }
        if (this.privateEndPort != other.privateEndPort) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.startPort != other.startPort) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.virtualMachineDisplayName == null ? other.virtualMachineDisplayName != null : !this.virtualMachineDisplayName.equals(other.virtualMachineDisplayName)) {
            return false;
        }
        if (this.virtualMachineId != other.virtualMachineId) {
            return false;
        }
        return !(this.virtualMachineName == null ? other.virtualMachineName != null : !this.virtualMachineName.equals(other.virtualMachineName));
    }

    public String toString() {
        return "[IPAddress=" + this.IPAddress + ", IPAddressId=" + this.IPAddressId + ", id=" + this.id + ", startPort=" + this.startPort + ", protocol=" + this.protocol + ", endPort=" + this.endPort + ", state=" + this.state + ", virtualMachineDisplayName=" + this.virtualMachineDisplayName + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName=" + this.virtualMachineName + "]";
    }

    public static class Builder {
        private long id;
        private String IPAddress;
        private long IPAddressId;
        private int startPort;
        private String protocol;
        public int endPort;
        private String state;
        private String virtualMachineDisplayName;
        public long virtualMachineId;
        private String virtualMachineName;
        private Set<String> CIDRs = ImmutableSet.of();
        private int privateEndPort;
        private int publicEndPort;
        public int publicPort;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder IPAddressId(long IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this;
        }

        public Builder publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this;
        }

        public IPForwardingRule build() {
            return new IPForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.startPort, this.protocol, this.endPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.publicEndPort, this.publicPort, this.CIDRs, this.privateEndPort);
        }
    }
}

