/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class DiskOffering
implements Comparable<DiskOffering> {
    private long id;
    private String name;
    @SerializedName(value="displaytext")
    private String displayText;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="disksize")
    private int diskSize;
    @SerializedName(value="iscustomized")
    private boolean customized;
    private String tags;

    public static Builder builder() {
        return new Builder();
    }

    public DiskOffering(long id, String name, String displayText, Date created, String domain, long domainId, int diskSize, boolean customized, Set<String> tags) {
        this.id = id;
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.diskSize = diskSize;
        this.customized = customized;
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
    }

    DiskOffering() {
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.customized ? 1231 : 1237);
        result = 31 * result + this.diskSize;
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskOffering other = (DiskOffering)obj;
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.customized != other.customized) {
            return false;
        }
        if (this.diskSize != other.diskSize) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public String toString() {
        return "DiskOffering{id=" + this.id + ", name='" + this.name + '\'' + ", displayText='" + this.displayText + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", diskSize=" + this.diskSize + ", customized=" + this.customized + ", tags='" + this.tags + '\'' + '}';
    }

    @Override
    public int compareTo(DiskOffering arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private String name;
        private String displayText;
        private Date created;
        private String domain;
        private long domainId;
        private int diskSize;
        private boolean customized;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder diskSize(int diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public Builder customized(boolean customized) {
            this.customized = customized;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public DiskOffering build() {
            return new DiskOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags);
        }
    }
}

