/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Host;

public class Cluster
implements Comparable<Cluster> {
    private long id;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;
    @SerializedName(value="clustertype")
    private Host.ClusterType clusterType;
    @SerializedName(value="hypervisortype")
    private String hypervisor;
    @SerializedName(value="managedstate")
    private ManagedState managedState;
    private String name;
    @SerializedName(value="podid")
    private long podId;
    @SerializedName(value="podname")
    private String podName;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    Cluster() {
    }

    public Cluster(long id, AllocationState allocationState, Host.ClusterType clusterType, String hypervisor, ManagedState managedState, String name, long podId, String podName, long zoneId, String zoneName) {
        this.id = id;
        this.allocationState = allocationState;
        this.clusterType = clusterType;
        this.hypervisor = hypervisor;
        this.managedState = managedState;
        this.name = name;
        this.podId = podId;
        this.podName = podName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public long getId() {
        return this.id;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public Host.ClusterType getClusterType() {
        return this.clusterType;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public ManagedState getManagedState() {
        return this.managedState;
    }

    public String getName() {
        return this.name;
    }

    public long getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        if (this.id != cluster.id) {
            return false;
        }
        if (this.podId != cluster.podId) {
            return false;
        }
        if (this.zoneId != cluster.zoneId) {
            return false;
        }
        if (this.allocationState != cluster.allocationState) {
            return false;
        }
        if (this.clusterType != cluster.clusterType) {
            return false;
        }
        if (this.hypervisor != null ? !this.hypervisor.equals(cluster.hypervisor) : cluster.hypervisor != null) {
            return false;
        }
        if (this.managedState != cluster.managedState) {
            return false;
        }
        if (this.name != null ? !this.name.equals(cluster.name) : cluster.name != null) {
            return false;
        }
        if (this.podName != null ? !this.podName.equals(cluster.podName) : cluster.podName != null) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(cluster.zoneName) : cluster.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.allocationState != null ? this.allocationState.hashCode() : 0);
        result = 31 * result + (this.clusterType != null ? this.clusterType.hashCode() : 0);
        result = 31 * result + (this.hypervisor != null ? this.hypervisor.hashCode() : 0);
        result = 31 * result + (this.managedState != null ? this.managedState.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.podId ^ this.podId >>> 32);
        result = 31 * result + (this.podName != null ? this.podName.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Cluster{id=" + this.id + ", allocationState=" + (Object)((Object)this.allocationState) + ", clusterType=" + (Object)((Object)this.clusterType) + ", hypervisor='" + this.hypervisor + '\'' + ", managedState=" + (Object)((Object)this.managedState) + ", name='" + this.name + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(Cluster other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private AllocationState allocationState;
        private Host.ClusterType clusterType;
        private String hypervisor;
        private ManagedState managedState;
        private String name;
        private long podId;
        private String podName;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder clusterType(Host.ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder managedState(ManagedState managedState) {
            this.managedState = managedState;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder podId(long podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Cluster build() {
            return new Cluster(this.id, this.allocationState, this.clusterType, this.hypervisor, this.managedState, this.name, this.podId, this.podName, this.zoneId, this.zoneName);
        }
    }

    public static enum ManagedState {
        MANAGED,
        PREPARE_UNMANAGED,
        UNMANAGED,
        PREPARE_UNMANAGED_ERROR,
        UNRECOGNIZED;


        public static ManagedState fromValue(String value) {
            try {
                return ManagedState.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

