/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class ApiKeyPair
implements Comparable<ApiKeyPair> {
    @SerializedName(value="apikey")
    private String apiKey;
    @SerializedName(value="secretkey")
    private String secretKey;

    public static Builder builder() {
        return new Builder();
    }

    ApiKeyPair() {
    }

    public ApiKeyPair(String apiKey, String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyPair that = (ApiKeyPair)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        return !(this.secretKey != null ? !this.secretKey.equals(that.secretKey) : that.secretKey != null);
    }

    public int hashCode() {
        int result = this.apiKey != null ? this.apiKey.hashCode() : 0;
        result = 31 * result + (this.secretKey != null ? this.secretKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApiKeyPair{apiKey='" + this.apiKey + '\'' + ", secretKey='" + this.secretKey + '\'' + '}';
    }

    @Override
    public int compareTo(ApiKeyPair arg0) {
        return this.apiKey.compareTo(arg0.getApiKey());
    }

    public static class Builder {
        private String apiKey;
        private String secretKey;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public ApiKeyPair build() {
            return new ApiKeyPair(this.apiKey, this.secretKey);
        }
    }
}

