/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAccountSecurityGroupPairsToIndexedQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindAccountSecurityGroupPairsToIndexedQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = (Provider)Preconditions.checkNotNull(uriBuilderProvider, (Object)"uriBuilderProvider");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Multimap), (Object)"this binder is only valid for Multimaps!");
        Multimap pairs = (Multimap)Preconditions.checkNotNull((Object)input, (Object)"account group pairs");
        Preconditions.checkArgument((pairs.size() > 0 ? 1 : 0) != 0, (Object)"you must specify at least one account, group pair");
        UriBuilder builder = (UriBuilder)this.uriBuilderProvider.get();
        builder.uri(request.getEndpoint());
        ImmutableMultimap.Builder map = ImmutableMultimap.builder().putAll(ModifyRequest.parseQueryToMap((String)request.getEndpoint().getQuery()));
        int i = 0;
        for (Map.Entry entry : pairs.entries()) {
            map.put((Object)String.format("usersecuritygrouplist[%d].account", i), entry.getKey()).put((Object)String.format("usersecuritygrouplist[%d].group", i++), entry.getValue());
        }
        builder.replaceQuery(ModifyRequest.makeQueryLine((Multimap)map.build(), null, (char[])new char[0]));
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }
}

