/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.predicates.PublicIPAddressPredicates;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PublicIPAddressPredicatesTest {
    public void testIsAvailableWhenAllocated() {
        PublicIPAddress address = PublicIPAddress.builder().state(PublicIPAddress.State.ALLOCATED).id(204L).build();
        assert (PublicIPAddressPredicates.available().apply((Object)address));
    }

    public void testIsNotAvailableWhenNotAllocated() {
        PublicIPAddress address = PublicIPAddress.builder().state(PublicIPAddress.State.ALLOCATING).id(204L).build();
        assert (!PublicIPAddressPredicates.available().apply((Object)address));
    }

    public void testIsNotAvailableWhenAssignedToVM() {
        PublicIPAddress address = PublicIPAddress.builder().state(PublicIPAddress.State.ALLOCATED).virtualMachineId(1L).id(204L).build();
        assert (!PublicIPAddressPredicates.available().apply((Object)address));
    }

    public void testIsNotAvailableWhenSourceNAT() {
        PublicIPAddress address = PublicIPAddress.builder().state(PublicIPAddress.State.ALLOCATED).isSourceNAT(true).id(204L).build();
        assert (!PublicIPAddressPredicates.available().apply((Object)address));
    }

    public void testIsNotAvailableWhenStaticNAT() {
        PublicIPAddress address = PublicIPAddress.builder().state(PublicIPAddress.State.ALLOCATED).isStaticNAT(true).id(204L).build();
        assert (!PublicIPAddressPredicates.available().apply((Object)address));
    }
}

