/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.features.GuestOSClient;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.predicates.OSCategoryIn;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class OSCategoryInTest {
    private CloudStackClient client;
    private GuestOSClient guestOSClient;
    private Set<String> acceptableCategories = ImmutableSet.of((Object)"Ubuntu");

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        this.guestOSClient = (GuestOSClient)EasyMock.createMock(GuestOSClient.class);
        EasyMock.expect((Object)this.client.getGuestOSClient()).andReturn((Object)this.guestOSClient).times(2);
        HashMap osCategories = Maps.newHashMap();
        osCategories.put(1L, "Ubuntu");
        osCategories.put(2L, "CentOS");
        osCategories.put(3L, "RHEL");
        EasyMock.expect((Object)this.guestOSClient.listOSCategories()).andReturn((Object)osCategories);
        ImmutableSet osTypes = ImmutableSet.of((Object)OSType.builder().id(10L).OSCategoryId(1L).description("Ubuntu 10.04 LTS").build(), (Object)OSType.builder().id(20L).OSCategoryId(2L).description("CentOS 5.4").build(), (Object)OSType.builder().id(30L).OSCategoryId(3L).description("RHEL 6").build());
        EasyMock.expect((Object)this.guestOSClient.listOSTypes(new ListOSTypesOptions[0])).andReturn((Object)osTypes);
        EasyMock.replay((Object[])new Object[]{this.client, this.guestOSClient});
    }

    @Test
    public void testTemplateInAcceptableCategory() {
        Assert.assertTrue((boolean)new OSCategoryIn(this.client).apply(this.acceptableCategories).apply((Object)Template.builder().OSTypeId(10L).build()));
        EasyMock.verify((Object[])new Object[]{this.client, this.guestOSClient});
    }

    @Test
    public void testTemplateNotInAcceptableCategory() {
        Assert.assertFalse((boolean)new OSCategoryIn(this.client).apply(this.acceptableCategories).apply((Object)Template.builder().OSTypeId(30L).build()));
        EasyMock.verify((Object[])new Object[]{this.client, this.guestOSClient});
    }
}

