/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudstack.config.CloudStackParserModule;
import org.jclouds.cloudstack.domain.Alert;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAlertsResponseTest
extends BaseSetParserTest<Alert> {
    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new CloudStackParserModule(), new GsonModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
                super.configure();
            }
        }});
    }

    public String resource() {
        return "/listalertsresponse.json";
    }

    @SelectJson(value="alert")
    public Set<Alert> expected() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.set(1, 2011);
        c.set(2, 11);
        c.set(5, 4);
        c.set(11, 10);
        c.set(12, 5);
        c.set(13, 2);
        return ImmutableSet.of((Object)Alert.builder().id(20L).description("Failed to deploy Vm with Id: 52").sent(c.getTime()).type("7").build());
    }
}

