/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateNetworkOptionsTest {
    public void testAccountInDomainId() {
        CreateNetworkOptions options = new CreateNetworkOptions().accountInDomain("adrian", 6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainIdStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.accountInDomain((String)"adrian", (long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testIsDefault() {
        CreateNetworkOptions options = new CreateNetworkOptions().isDefault(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isdefault"));
    }

    public void testIsDefaultStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.isDefault((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isdefault"));
    }

    public void testIsShared() {
        CreateNetworkOptions options = new CreateNetworkOptions().isShared(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isshared"));
    }

    public void testIsSharedStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.isShared((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isshared"));
    }

    public void testStartIP() {
        CreateNetworkOptions options = new CreateNetworkOptions().startIP("1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"startip"));
    }

    public void testStartIPStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.startIP((String)"1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"startip"));
    }

    public void testEndIP() {
        CreateNetworkOptions options = new CreateNetworkOptions().endIP("1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"endip"));
    }

    public void testEndIPStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.endIP((String)"1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"endip"));
    }

    public void testGateway() {
        CreateNetworkOptions options = new CreateNetworkOptions().gateway("1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"gateway"));
    }

    public void testGatewayStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.gateway((String)"1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"gateway"));
    }

    public void testNetmask() {
        CreateNetworkOptions options = new CreateNetworkOptions().netmask("1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"netmask"));
    }

    public void testNetmaskStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.netmask((String)"1.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"netmask"));
    }

    public void testNetworkDomain() {
        CreateNetworkOptions options = new CreateNetworkOptions().networkDomain("network.com");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"network.com"), (Collection)options.buildQueryParameters().get((Object)"networkdomain"));
    }

    public void testNetworkDomainStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.networkDomain((String)"network.com");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"network.com"), (Collection)options.buildQueryParameters().get((Object)"networkdomain"));
    }

    public void testVlan() {
        CreateNetworkOptions options = new CreateNetworkOptions().vlan("tag");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }

    public void testVlanStatic() {
        CreateNetworkOptions options = CreateNetworkOptions.Builder.vlan((String)"tag");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }
}

