/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.common.cache.LoadingCache;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.cloudstack.handlers.RetryOnRenewAndLogoutOnClose;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RetryOnRenewAndLogoutOnCloseTest")
public class RetryOnRenewAndLogoutOnCloseTest {
    @Test
    public void test401ShouldRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        SessionClient sessionClient = (SessionClient)EasyMock.createMock(SessionClient.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        cache.invalidateAll();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{cache, command});
        HttpResponse response = HttpResponse.builder().payload((Payload)Payloads.newStringPayload((String)"TODO: What state can we retry?")).statusCode(401).build();
        RetryOnRenewAndLogoutOnClose retry = new RetryOnRenewAndLogoutOnClose(cache, sessionClient);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{cache, command});
    }
}

