/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateExtraction;
import org.jclouds.cloudstack.functions.ParseAsyncJobFromHttpResponse;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseAsyncJobFromHttpResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
            super.configure();
        }
    }});

    public void testWithNoResult() {
        String input = "{ \"queryasyncjobresultresponse\" : {\"jobid\":860,\"jobstatus\":0,\"jobprocstatus\":0,\"jobresultcode\":0} }";
        AsyncJob expects = AsyncJob.builder().id(860L).status(AsyncJob.Status.IN_PROGRESS).progress(0).resultCode(AsyncJob.ResultCode.SUCCESS).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)input)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testWithSuccessTrueResultSetsNullResult() {
        String input = "{ \"queryasyncjobresultresponse\" : {\"jobid\":1138,\"jobstatus\":1,\"jobprocstatus\":0,\"jobresultcode\":0,\"jobresulttype\":\"object\",\"jobresult\":{\"success\":true}} }";
        AsyncJob expects = AsyncJob.builder().id(1138L).status(AsyncJob.Status.SUCCEEDED).progress(0).resultType("object").resultCode(AsyncJob.ResultCode.SUCCESS).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)input)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testWithErrorSetsResultNullSoToAvoidClassCastExceptions() {
        String input = "{ \"queryasyncjobresultresponse\" : {\"jobid\":1103,\"jobstatus\":2,\"jobprocstatus\":0,\"jobresultcode\":530,\"jobresulttype\":\"object\",\"jobresult\":{\"errorcode\":530,\"errortext\":\"Internal error executing command, please contact your system administrator\"}} }";
        AsyncJob expects = AsyncJob.builder().id(1103L).status(AsyncJob.Status.FAILED).progress(0).resultType("object").error(new AsyncJobError(AsyncJobError.ErrorCode.INTERNAL_ERROR, "Internal error executing command, please contact your system administrator")).resultCode(AsyncJob.ResultCode.FAIL).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)input)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testWithUnknownResultReturnsStringifiedJson() {
        String input = "{ \"queryasyncjobresultresponse\" : {\"jobid\":860,\"jobstatus\":0,\"jobprocstatus\":0,\"jobresultcode\":0,\"jobresult\":{\"foo\":{\"bar\":1}}}}";
        AsyncJob expects = AsyncJob.builder().id(860L).status(AsyncJob.Status.IN_PROGRESS).progress(0).resultCode(AsyncJob.ResultCode.SUCCESS).result((Object)"{\"bar\":1}").build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)input)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testWithBadResultReturnsMap() {
        String input = "{ \"queryasyncjobresultresponse\" : {\"jobid\":860,\"jobstatus\":0,\"jobprocstatus\":0,\"jobresultcode\":0,\"jobresult\":{\"foo\":{\"bar\":1},\"foo2\":{\"bar2\":2}}}}";
        AsyncJob expects = AsyncJob.builder().id(860L).status(AsyncJob.Status.IN_PROGRESS).progress(0).resultCode(AsyncJob.ResultCode.SUCCESS).result((Object)ImmutableMap.of((Object)"foo", (Object)new JsonBall("{\"bar\":1}"), (Object)"foo2", (Object)new JsonBall("{\"bar2\":2}"))).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)input)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testPublicIPAddress() {
        InputStream is = this.getClass().getResourceAsStream("/queryasyncjobresultresponse-ipaddress.json");
        AsyncJob expects = AsyncJob.builder().id(860L).status(AsyncJob.Status.SUCCEEDED).progress(0).resultType("object").resultCode(AsyncJob.ResultCode.SUCCESS).result((Object)PublicIPAddress.builder().id(6L).IPAddress("72.52.126.35").allocated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-02-23T20:15:01-0800")).zoneId(1L).zoneName("San Jose 1").isSourceNAT(false).account("adrian").domainId(1L).domain("ROOT").usesVirtualNetwork(true).isStaticNAT(false).associatedNetworkId(204L).networkId(200L).state(PublicIPAddress.State.ALLOCATING).build()).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testIPForwardingRule() {
        InputStream is = this.getClass().getResourceAsStream("/queryasyncjobresultresponse-ipforwardingrule.json");
        AsyncJob expects = AsyncJob.builder().id(1133L).status(AsyncJob.Status.SUCCEEDED).progress(0).resultType("object").resultCode(AsyncJob.ResultCode.SUCCESS).result((Object)IPForwardingRule.builder().id(109L).protocol("tcp").virtualMachineId(226L).virtualMachineName("i-3-226-VM").IPAddressId(36L).IPAddress("72.52.126.65").startPort(22).endPort(22).state("Active").build()).build();
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Object)response, (Object)expects);
    }

    public void testOverloadedKeyName() {
        InputStream is = this.getClass().getResourceAsStream("/queryasyncjobresultresponse-createtemplate.json");
        ParseAsyncJobFromHttpResponse parser = (ParseAsyncJobFromHttpResponse)this.i.getInstance(ParseAsyncJobFromHttpResponse.class);
        AsyncJob response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertTrue((boolean)(response.getResult() instanceof Template), (String)("response expected to be Template, actually is " + response.getResult().getClass()));
        is = this.getClass().getResourceAsStream("/queryasyncjobresultresponse-extracttemplate.json");
        response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertTrue((boolean)(response.getResult() instanceof TemplateExtraction), (String)("response expected to be TemplateExtraction, actually is " + response.getResult().getClass()));
    }
}

