/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import java.net.URI;
import org.jclouds.PropertiesBuilder;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.rest.BaseRestClientTest;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.RestContextBuilder;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QuerySignerTest")
public class QuerySignerTest {
    public static final RestContextSpec<IntegrationTestClient, IntegrationTestAsyncClient> DUMMY_SPEC = new RestContextSpec("cloudstack", "http://localhost:8080/client/api", "2.2", "", "", "apiKey", "secretKey", IntegrationTestClient.class, IntegrationTestAsyncClient.class, PropertiesBuilder.class, RestContextBuilder.class, (Iterable)ImmutableList.of((Object)new BaseRestClientTest.MockModule(), (Object)new NullLoggingModule(), (Object)new AbstractModule(){

        protected void configure() {
            this.bind(RequestSigner.class).to(QuerySigner.class);
        }
    }));

    @Test
    void testCreateStringToSign() {
        QuerySigner filter = (QuerySigner)RestContextFactory.createContextBuilder(DUMMY_SPEC).buildInjector().getInstance(QuerySigner.class);
        Assert.assertEquals((String)filter.createStringToSign(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?command=listZones")).build()), (String)"apikey=apikey&command=listzones");
    }

    @Test
    void testFilter() {
        QuerySigner filter = (QuerySigner)RestContextFactory.createContextBuilder(DUMMY_SPEC).buildInjector().getInstance(QuerySigner.class);
        Assert.assertEquals((String)filter.filter(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?command=listZones")).build()).getRequestLine(), (String)"GET http://localhost:8080/client/api?command=listZones&apiKey=apiKey&signature=2UG8AcnMaozL3BINdjgkJ%2BRzjEY%3D HTTP/1.1");
    }

    @Test
    void testFilterTwice() {
        QuerySigner filter = (QuerySigner)RestContextFactory.createContextBuilder(DUMMY_SPEC).buildInjector().getInstance(QuerySigner.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?command=listZones")).build();
        for (int i = 0; i < 2; ++i) {
            request = filter.filter(request);
            Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://localhost:8080/client/api?command=listZones&apiKey=apiKey&signature=2UG8AcnMaozL3BINdjgkJ%2BRzjEY%3D HTTP/1.1");
        }
    }
}

