/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.features.VolumeAsyncClient;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeAsyncClientTest")
public class VolumeAsyncClientTest
extends BaseCloudStackAsyncClientTest<VolumeAsyncClient> {
    public void testListVolumes() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("listVolumes", ListVolumesOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listVolumes HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetVolume() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("getVolume", Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{111L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listVolumes&id=111 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVolumeWithSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("createVolumeFromSnapshotInZone", String.class, Long.TYPE, Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"jclouds-volume", 999L, 111L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createVolume&name=jclouds-volume&zoneid=111&snapshotid=999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVolumeFromDiskOffering() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("createVolumeFromDiskOfferingInZone", String.class, Long.TYPE, Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"jclouds-volume", 999L, 111L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createVolume&name=jclouds-volume&zoneid=111&diskofferingid=999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testAttachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("attachVolume", Long.TYPE, Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{111L, 999L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=attachVolume&id=111&virtualmachineid=999 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDetachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("detachVolume", Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{111L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=detachVolume&id=111 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteVolume() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VolumeAsyncClient.class.getMethod("deleteVolume", Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{111L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteVolume&id=111 HTTP/1.1");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<VolumeAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<VolumeAsyncClient>>(){};
    }
}

