/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.NoSuchElementException;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.features.VirtualMachineClientLiveTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SecurityGroupClientLiveTest")
public class SecurityGroupClientLiveTest
extends BaseCloudStackClientLiveTest {
    private SecurityGroup group;
    private boolean securityGroupsSupported;
    private VirtualMachine vm;
    private Zone zone;

    public SecurityGroupClientLiveTest() {
        this.prefix = this.prefix + "2";
    }

    @Test
    public void testCreateDestroySecurityGroup() {
        try {
            this.zone = (Zone)Iterables.find((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[0]), (Predicate)new Predicate<Zone>(){

                public boolean apply(Zone arg0) {
                    return arg0.isSecurityGroupsEnabled();
                }
            });
            this.securityGroupsSupported = true;
            for (SecurityGroup securityGroup : this.client.getSecurityGroupClient().listSecurityGroups(new ListSecurityGroupsOptions[]{ListSecurityGroupsOptions.Builder.named((String)this.prefix)})) {
                for (IngressRule rule : securityGroup.getIngressRules()) {
                    Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getSecurityGroupClient().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0])), (String)rule.toString());
                }
                this.client.getSecurityGroupClient().deleteSecurityGroup(securityGroup.getId());
            }
            this.group = this.client.getSecurityGroupClient().createSecurityGroup(this.prefix);
            Assert.assertEquals((String)this.group.getName(), (String)this.prefix);
            this.checkGroup(this.group);
            try {
                this.client.getSecurityGroupClient().createSecurityGroup(this.prefix);
                assert (false);
            }
            catch (IllegalStateException e) {}
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
    }

    public static String getCurrentCIDR() throws IOException {
        URL url = new URL("http://checkip.amazonaws.com/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        return Strings2.toStringAndClose((InputStream)connection.getInputStream()).trim() + "/32";
    }

    @Test(dependsOnMethods={"testCreateDestroySecurityGroup"})
    public void testCreateIngress() throws Exception {
        if (!this.securityGroupsSupported) {
            return;
        }
        String cidr = SecurityGroupClientLiveTest.getCurrentCIDR();
        ImmutableSet cidrs = ImmutableSet.of((Object)cidr);
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getSecurityGroupClient().authorizeIngressICMPToCIDRs(this.group.getId(), 0, 8, (Iterable)cidrs, new AccountInDomainOptions[0])), (String)this.group.toString());
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getSecurityGroupClient().authorizeIngressPortsToCIDRs(this.group.getId(), "TCP", 22, 22, (Iterable)cidrs, new AccountInDomainOptions[0])), (String)this.group.toString());
        AccountInDomainOptions.Builder.accountInDomain((String)this.group.getAccount(), (long)this.group.getDomainId());
        this.group = (SecurityGroup)Iterables.find((Iterable)this.client.getSecurityGroupClient().listSecurityGroups(new ListSecurityGroupsOptions[0]), (Predicate)new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup input) {
                return input.getId() == SecurityGroupClientLiveTest.this.group.getId();
            }
        });
        IngressRule ICMPPingRule = (IngressRule)Iterables.find((Iterable)this.group.getIngressRules(), (Predicate)new Predicate<IngressRule>(){

            public boolean apply(IngressRule input) {
                return "icmp".equals(input.getProtocol());
            }
        });
        assert (ICMPPingRule.getId() > 0L) : ICMPPingRule;
        assert ("icmp".equals(ICMPPingRule.getProtocol())) : ICMPPingRule;
        assert (ICMPPingRule.getStartPort() == -1) : ICMPPingRule;
        assert (ICMPPingRule.getEndPort() == -1) : ICMPPingRule;
        assert (ICMPPingRule.getICMPCode() == 0) : ICMPPingRule;
        assert (ICMPPingRule.getICMPType() == 8) : ICMPPingRule;
        assert (ICMPPingRule.getAccount() == null) : ICMPPingRule;
        assert (ICMPPingRule.getSecurityGroupName() == null) : ICMPPingRule;
        assert (cidr.equals(ICMPPingRule.getCIDR())) : ICMPPingRule;
        IngressRule SSHRule = (IngressRule)Iterables.find((Iterable)this.group.getIngressRules(), (Predicate)new Predicate<IngressRule>(){

            public boolean apply(IngressRule input) {
                return "tcp".equals(input.getProtocol());
            }
        });
        assert (SSHRule.getId() > 0L) : SSHRule;
        assert ("tcp".equals(SSHRule.getProtocol())) : SSHRule;
        assert (SSHRule.getStartPort() == 22) : SSHRule;
        assert (SSHRule.getEndPort() == 22) : SSHRule;
        assert (SSHRule.getICMPCode() == -1) : SSHRule;
        assert (SSHRule.getICMPType() == -1) : SSHRule;
        assert (SSHRule.getAccount() == null) : SSHRule;
        assert (SSHRule.getSecurityGroupName() == null) : SSHRule;
        assert (cidr.equals(SSHRule.getCIDR())) : SSHRule;
    }

    public void testListSecurityGroup() throws Exception {
        if (!this.securityGroupsSupported) {
            return;
        }
        for (SecurityGroup securityGroup : this.client.getSecurityGroupClient().listSecurityGroups(new ListSecurityGroupsOptions[0])) {
            this.checkGroup(securityGroup);
        }
    }

    @Test(dependsOnMethods={"testCreateIngress"})
    public void testCreateVMInSecurityGroup() throws Exception {
        if (!this.securityGroupsSupported) {
            return;
        }
        Long defaultTemplate = this.imageId != null && !"".equals(this.imageId) ? new Long(this.imageId) : null;
        this.vm = VirtualMachineClientLiveTest.createVirtualMachineWithSecurityGroupInZone(this.zone.getId(), SecurityGroupClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.zone.getId()), this.group.getId(), this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
        if (this.vm.getPassword() != null && !this.loginCredentials.hasPasswordOption()) {
            this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
        }
        this.checkSSH(new IPSocket(this.vm.getIPAddress(), 22));
    }

    protected void checkGroup(SecurityGroup group) {
        if (group.getIngressRules().size() <= 1) {
            Assert.assertEquals((Object)group, (Object)this.client.getSecurityGroupClient().getSecurityGroup(group.getId()));
        }
        assert (group.getId() > 0L) : group;
        assert (group.getName() != null) : group;
        assert (group.getAccount() != null) : group;
        assert (group.getDomain() != null) : group;
        assert (group.getDomainId() >= 0L) : group;
        assert (group.getIngressRules() != null) : group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateVMWithoutSecurityGroupAssignsDefault() throws Exception {
        if (!this.securityGroupsSupported) {
            return;
        }
        Long defaultTemplate = this.imageId != null && !"".equals(this.imageId) ? new Long(this.imageId) : null;
        VirtualMachine newVm = VirtualMachineClientLiveTest.createVirtualMachineWithOptionsInZone(DeployVirtualMachineOptions.NONE, this.zone.getId(), SecurityGroupClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.zone.getId()), this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
        try {
            VirtualMachine runningVm = this.client.getVirtualMachineClient().getVirtualMachine(newVm.getId());
            Assert.assertTrue((runningVm.getSecurityGroups().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((String)((SecurityGroup)Iterables.getOnlyElement((Iterable)runningVm.getSecurityGroups())).getName(), (String)"default");
        }
        finally {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(newVm.getId())));
        }
    }

    @Override
    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.vm != null) {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vm.getId())));
        }
        if (this.group != null) {
            for (IngressRule rule : this.group.getIngressRules()) {
                Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getSecurityGroupClient().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0])), (String)rule.toString());
            }
            this.client.getSecurityGroupClient().deleteSecurityGroup(this.group.getId());
            Assert.assertEquals((Object)this.client.getSecurityGroupClient().getSecurityGroup(this.group.getId()), null);
        }
        super.tearDown();
    }
}

