/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GuestOSClientLiveTest")
public class GuestOSClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testListOSTypes() throws Exception {
        Set response = this.client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (OSType type : response) {
            OSType newDetails = (OSType)Iterables.getOnlyElement((Iterable)this.client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[]{ListOSTypesOptions.Builder.id((long)type.getId())}));
            Assert.assertEquals((long)type.getId(), (long)newDetails.getId());
            this.checkOSType(type);
        }
    }

    public void testListOSCategories() throws Exception {
        Map response = this.client.getGuestOSClient().listOSCategories();
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (Map.Entry<Long, String> entry : response.entrySet()) {
            this.checkOSCategory(entry);
        }
    }

    protected void checkOSCategory(Map.Entry<Long, String> category) {
        Assert.assertEquals(category, (Object)this.client.getGuestOSClient().getOSCategory(category.getKey().longValue()));
        assert (category.getKey() > 0L) : category;
        assert (category.getValue() != null) : category;
    }

    protected void checkOSType(OSType type) {
        Assert.assertEquals((long)type.getId(), (long)this.client.getGuestOSClient().getOSType(type.getId()).getId());
        assert (type.getId() > 0L) : type;
        assert (type.getOSCategoryId() > 0L) : type;
        assert (type.getDescription() != null) : type;
    }
}

