/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import org.jclouds.cloudstack.features.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.features.GlobalUsageAsyncClient;
import org.jclouds.cloudstack.options.GenerateUsageRecordsOptions;
import org.jclouds.cloudstack.options.ListUsageRecordsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalUsageAsyncClientTest")
public class GlobalUsageAsyncClientTest
extends BaseCloudStackAsyncClientTest<GlobalUsageAsyncClient> {
    public void testGenerateUsageRecords() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Method method = GlobalUsageAsyncClient.class.getMethod("generateUsageRecords", Date.class, Date.class, GenerateUsageRecordsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{start, end});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=generateUsageRecords&startdate=2012-01-01&enddate=2012-01-31 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGenerateUsageRecordsOptions() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Method method = GlobalUsageAsyncClient.class.getMethod("generateUsageRecords", Date.class, Date.class, GenerateUsageRecordsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{start, end, GenerateUsageRecordsOptions.Builder.domainId((long)42L)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=generateUsageRecords&startdate=2012-01-01&enddate=2012-01-31&domainid=42 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListUsageRecords() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Method method = GlobalUsageAsyncClient.class.getMethod("listUsageRecords", Date.class, Date.class, ListUsageRecordsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{start, end});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listUsageRecords&startdate=2012-01-01&enddate=2012-01-31 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListUsageRecordsOptions() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Method method = GlobalUsageAsyncClient.class.getMethod("listUsageRecords", Date.class, Date.class, ListUsageRecordsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{start, end, ListUsageRecordsOptions.Builder.accountInDomain((String)"fred", (long)42L).accountId(41L).keyword("bob")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listUsageRecords&startdate=2012-01-01&enddate=2012-01-31&account=fred&domainid=42&accountid=41&keyword=bob HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<GlobalUsageAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GlobalUsageAsyncClient>>(){};
    }
}

