/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Strings;
import java.util.Set;
import org.jclouds.cloudstack.domain.StoragePool;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListStoragePoolsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalStoragePoolClientLiveTest")
public class GlobalStoragePoolClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListStoragePools() throws Exception {
        Assert.assertTrue((boolean)this.globalAdminEnabled, (String)"Test cannot run without global admin identity and credentials");
        Set result = this.globalAdminClient.getStoragePoolClient().listStoragePools(new ListStoragePoolsOptions[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        for (StoragePool pool : result) {
            Assert.assertTrue((pool.getId() > 0L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getName()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getPath()));
            Assert.assertNotNull((Object)pool.getTags());
            Assert.assertTrue((pool.getState() != StoragePool.State.UNRECOGNIZED ? 1 : 0) != 0);
            Assert.assertTrue((pool.getType() != StoragePool.Type.UNRECOGNIZED ? 1 : 0) != 0);
            Assert.assertTrue((pool.getZoneId() > 0L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getZoneName()));
            Assert.assertTrue((pool.getPodId() > 0L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getPodName()));
            Assert.assertTrue((pool.getClusterId() > 0L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getClusterName()));
            Assert.assertNotNull((Object)pool.getCreated());
            Assert.assertTrue((pool.getDiskSizeTotal() > 0L ? 1 : 0) != 0);
        }
    }
}

