/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Strings;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListClustersOptions;
import org.jclouds.cloudstack.options.ListHostsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalHostClientLiveTest")
public class GlobalHostClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListHosts() throws Exception {
        Assert.assertTrue((boolean)this.globalAdminEnabled, (String)"Test cannot run without global admin identity and credentials");
        Set hosts = this.globalAdminClient.getHostClient().listHosts(new ListHostsOptions[0]);
        assert (hosts.size() > 0) : hosts;
        for (Host host : hosts) {
            this.checkHost(host);
        }
    }

    private void checkHost(Host host) {
        if (host.getType() == Host.Type.ROUTING) {
            assert (host.getCpuNumber() > 0);
            assert (host.getAverageLoad() >= 0);
            assert (host.getHypervisor() != null);
        }
        assert (host.getAllocationState() != null);
        assert (host.getEvents() != null);
        if (host.getType() == Host.Type.SECONDARY_STORAGE_VM) assert (host.getName().startsWith("s-"));
        if (host.getType() == Host.Type.CONSOLE_PROXY) assert (host.getName().startsWith("v-"));
    }

    @Test(groups={"live"}, enabled=true)
    public void testListClusters() throws Exception {
        Assert.assertTrue((boolean)this.globalAdminEnabled, (String)"Test cannot run without global admin identity and credentials");
        Set clusters = this.globalAdminClient.getHostClient().listClusters(new ListClustersOptions[0]);
        assert (clusters.size() > 0) : clusters;
        for (Cluster cluster : clusters) {
            this.checkCluster(cluster);
        }
    }

    private void checkCluster(Cluster cluster) {
        Assert.assertTrue((cluster.getId() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getName()));
        Assert.assertTrue((cluster.getAllocationState() != AllocationState.UNKNOWN ? 1 : 0) != 0);
        Assert.assertTrue((cluster.getClusterType() != Host.ClusterType.UNKNOWN ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getHypervisor()));
        Assert.assertTrue((cluster.getManagedState() != Cluster.ManagedState.UNRECOGNIZED ? 1 : 0) != 0);
        Assert.assertTrue((cluster.getPodId() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getPodName()));
        Assert.assertTrue((cluster.getZoneId() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)cluster.getZoneName()));
    }
}

