/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.Event;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListEventsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="EventClientLiveTest")
public class EventClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testlistEventTypes() throws Exception {
        Set response = this.client.getEventClient().listEventTypes();
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (String type : response) {
            this.checkEventType(type);
        }
    }

    public void testlistEvents() throws Exception {
        Set response = this.client.getEventClient().listEvents(new ListEventsOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (Event event : response) {
            this.checkEvent(event);
        }
    }

    private void checkEvent(Event event) {
        assert (event.getAccount() != null) : event;
        assert (event.getCreated() != null) : event;
        assert (event.getDescription() != null) : event;
        assert (event.getDomain() != null) : event;
        assert (event.getId() != 0L) : event;
        assert (event.getLevel() != null) : event;
        assert (event.getState() != null) : event;
        assert (event.getType() != null) : event;
        assert (event.getUsername() != null) : event;
    }

    protected void checkEventType(String eventType) {
        assert (eventType != null) : eventType;
    }
}

