/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.features.EventAsyncClient;
import org.jclouds.cloudstack.functions.ParseEventTypesFromHttpResponse;
import org.jclouds.cloudstack.options.ListEventsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EventAsyncClientTest")
public class EventAsyncClientTest
extends BaseCloudStackAsyncClientTest<EventAsyncClient> {
    public void testListEventTypes() throws SecurityException, NoSuchMethodException, IOException {
        Method method = EventAsyncClient.class.getMethod("listEventTypes", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listEventTypes HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseEventTypesFromHttpResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListEvents() throws SecurityException, NoSuchMethodException, IOException {
        Method method = EventAsyncClient.class.getMethod("listEvents", ListEventsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listEvents HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testEventsListOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = EventAsyncClient.class.getMethod("listEvents", ListEventsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ListEventsOptions.Builder.account((String)"jclouds")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listEvents&account=jclouds HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<EventAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<EventAsyncClient>>(){};
    }
}

