/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackDomainClient;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.features.DomainDomainClient;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DomainDomainClientExpectTest")
public class DomainDomainClientExpectTest
extends BaseCloudStackRestClientExpectTest<DomainDomainClient> {
    public void testListDomainsWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&apiKey=identity&signature=MmzRB%2FpKlYyWy7kE3IMXrg4BUtk%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listdomainsresponse.json")).build());
        Assert.assertEquals((Set)client.listDomains(new ListDomainsOptions[0]), (Set)ImmutableSet.of((Object)Domain.builder().id(1L).name("ROOT").level(0L).hasChild(true).build(), (Object)Domain.builder().id(2L).name("jclouds1").level(1L).parentDomainId(1L).parentDomainName("ROOT").hasChild(false).build()));
    }

    public void testListDomainsWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&apiKey=identity&signature=MmzRB%2FpKlYyWy7kE3IMXrg4BUtk%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listDomains(new ListDomainsOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetDomainWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&id=1&apiKey=identity&signature=emQKWkVhospRkaUzjKljME2rW0k%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getdomainresponse.json")).build());
        Assert.assertEquals((Object)client.getDomainById(1L), (Object)Domain.builder().id(1L).name("ROOT").level(0L).hasChild(true).build());
    }

    public void testGetDomainWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&id=1&apiKey=identity&signature=emQKWkVhospRkaUzjKljME2rW0k%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getDomainById(1L));
    }

    public void testListDomainChildrenWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomainChildren&id=1&isrecursive=true&apiKey=identity&signature=bDMSkjme8k0ANUPm4YiTYKe2N88%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listdomainchildrenresponse.json")).build());
        Assert.assertEquals((Set)client.listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((long)1L).isRecursive(true)}), (Set)ImmutableSet.of((Object)Domain.builder().id(2L).name("jclouds1").level(1L).parentDomainId(1L).parentDomainName("ROOT").hasChild(false).build(), (Object)Domain.builder().id(3L).name("jclouds2").level(1L).parentDomainId(1L).parentDomainName("ROOT").hasChild(false).build()));
    }

    public void testListDomainChildrenWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomainChildren&id=1&isrecursive=true&apiKey=identity&signature=bDMSkjme8k0ANUPm4YiTYKe2N88%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((long)1L).isRecursive(true)}), (Set)ImmutableSet.of());
    }

    @Override
    protected DomainDomainClient clientFrom(CloudStackContext context) {
        return ((CloudStackDomainClient)context.getDomainContext().getApi()).getDomainClient();
    }
}

