/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.cloudstack.CloudStackAsyncClient;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackDomainAsyncClient;
import org.jclouds.cloudstack.CloudStackDomainClient;
import org.jclouds.cloudstack.CloudStackGlobalAsyncClient;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.functions.ReuseOrAssociateNewPublicIPAddress;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.predicates.CorrectHypervisorForZone;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.jclouds.cloudstack.predicates.OSCategoryIn;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.cloudstack.predicates.UserPredicates;
import org.jclouds.cloudstack.predicates.VirtualMachineDestroyed;
import org.jclouds.cloudstack.predicates.VirtualMachineRunning;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.compute.BaseVersionedServiceLiveTest;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;

public class BaseCloudStackClientLiveTest
extends BaseVersionedServiceLiveTest {
    protected String domainAdminIdentity;
    protected String domainAdminCredential;
    protected String globalAdminIdentity;
    protected String globalAdminCredential;
    protected String prefix = System.getProperty("user.name");
    protected CloudStackContext computeContext;
    protected ComputeService computeClient;
    protected RestContext<CloudStackClient, CloudStackAsyncClient> context;
    protected CloudStackClient client;
    protected CloudStackClient adminClient;
    protected User user;
    protected Predicate<IPSocket> socketTester;
    protected RetryablePredicate<Long> jobComplete;
    protected RetryablePredicate<Long> adminJobComplete;
    protected RetryablePredicate<VirtualMachine> virtualMachineRunning;
    protected RetryablePredicate<VirtualMachine> adminVirtualMachineRunning;
    protected RetryablePredicate<VirtualMachine> virtualMachineDestroyed;
    protected RetryablePredicate<VirtualMachine> adminVirtualMachineDestroyed;
    protected SshClient.Factory sshFactory;
    protected Injector injector;
    protected ReuseOrAssociateNewPublicIPAddress reuseOrAssociate;
    protected boolean domainAdminEnabled;
    protected CloudStackContext domainAdminComputeContext;
    protected RestContext<CloudStackDomainClient, CloudStackDomainAsyncClient> domainAdminContext;
    protected CloudStackDomainClient domainAdminClient;
    protected User domainAdminUser;
    protected boolean globalAdminEnabled;
    protected CloudStackContext globalAdminComputeContext;
    protected RestContext<CloudStackGlobalClient, CloudStackGlobalAsyncClient> globalAdminContext;
    protected CloudStackGlobalClient globalAdminClient;
    protected User globalAdminUser;

    public BaseCloudStackClientLiveTest() {
        this.provider = "cloudstack";
    }

    protected void setupCredentials() {
        super.setupCredentials();
        this.domainAdminIdentity = Strings.emptyToNull((String)System.getProperty("test." + this.provider + ".domainAdminIdentity"));
        this.domainAdminCredential = Strings.emptyToNull((String)System.getProperty("test." + this.provider + ".domainAdminCredential"));
        this.globalAdminIdentity = Strings.emptyToNull((String)System.getProperty("test." + this.provider + ".globalAdminIdentity"));
        this.globalAdminCredential = Strings.emptyToNull((String)System.getProperty("test." + this.provider + ".globalAdminCredential"));
    }

    protected Properties setupDomainAdminProperties() {
        if (this.domainAdminIdentity != null && this.domainAdminCredential != null) {
            Properties overrides = this.setupProperties();
            overrides.setProperty(this.provider + ".identity", this.domainAdminIdentity);
            overrides.setProperty(this.provider + ".credential", this.domainAdminCredential);
            return overrides;
        }
        return null;
    }

    protected Properties setupGlobalAdminProperties() {
        if (this.globalAdminIdentity != null && this.globalAdminCredential != null) {
            Properties overrides = this.setupProperties();
            overrides.setProperty(this.provider + ".identity", this.globalAdminIdentity);
            overrides.setProperty(this.provider + ".credential", this.globalAdminCredential);
            return overrides;
        }
        return null;
    }

    public static long defaultTemplateOrPreferredInZone(Long defaultTemplate, CloudStackClient client, long zoneId) {
        long templateId = defaultTemplate != null ? defaultTemplate : BaseCloudStackClientLiveTest.getTemplateForZone(client, zoneId);
        return templateId;
    }

    public static long getTemplateForZone(CloudStackClient client, long zoneId) {
        ImmutableSet acceptableCategories = ImmutableSet.of((Object)"Ubuntu", (Object)"CentOS");
        Predicate hypervisorPredicate = new CorrectHypervisorForZone(client).apply(Long.valueOf(zoneId));
        Predicate osTypePredicate = new OSCategoryIn(client).apply((Set)acceptableCategories);
        Predicate templatePredicate = Predicates.and((Predicate[])new Predicate[]{TemplatePredicates.isReady(), hypervisorPredicate, osTypePredicate});
        Iterable templates = Iterables.filter((Iterable)client.getTemplateClient().listTemplates(ListTemplatesOptions.Builder.zoneId((long)zoneId)), (Predicate)templatePredicate);
        if (Iterables.any((Iterable)templates, (Predicate)TemplatePredicates.isPasswordEnabled())) {
            templates = Iterables.filter((Iterable)templates, (Predicate)TemplatePredicates.isPasswordEnabled());
        }
        if (Iterables.size((Iterable)templates) == 0) {
            throw new NoSuchElementException(templatePredicate.toString());
        }
        long templateId = ((Template)Iterables.get((Iterable)templates, (int)0)).getId();
        return templateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSSH(IPSocket socket) {
        this.socketTester.apply((Object)socket);
        SshClient client = this.sshFactory.create(socket, this.loginCredentials);
        try {
            client.connect();
            ExecResponse exec = client.exec("echo hello");
            System.out.println(exec);
            Assert.assertEquals((String)exec.getOutput().trim(), (String)"hello");
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        this.computeContext = (CloudStackContext)CloudStackContext.class.cast(new ComputeServiceContextFactory(this.setupRestProperties()).createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()), this.setupProperties()));
        this.computeClient = this.computeContext.getComputeService();
        this.context = this.computeContext.getProviderSpecificContext();
        this.client = (CloudStackClient)this.context.getApi();
        this.user = BaseCloudStackClientLiveTest.verifyCurrentUserIsOfType(this.context, Account.Type.USER);
        boolean bl = this.domainAdminEnabled = this.setupDomainAdminProperties() != null;
        if (this.domainAdminEnabled) {
            this.domainAdminComputeContext = (CloudStackContext)CloudStackContext.class.cast(new ComputeServiceContextFactory(this.setupRestProperties()).createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()), this.setupDomainAdminProperties()));
            this.domainAdminContext = this.domainAdminComputeContext.getDomainContext();
            this.domainAdminClient = (CloudStackDomainClient)this.domainAdminContext.getApi();
            this.domainAdminUser = BaseCloudStackClientLiveTest.verifyCurrentUserIsOfType(this.domainAdminContext, Account.Type.DOMAIN_ADMIN);
            this.adminClient = (CloudStackClient)this.domainAdminContext.getApi();
        }
        boolean bl2 = this.globalAdminEnabled = this.setupGlobalAdminProperties() != null;
        if (this.globalAdminEnabled) {
            this.globalAdminComputeContext = (CloudStackContext)CloudStackContext.class.cast(new ComputeServiceContextFactory(this.setupRestProperties()).createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()), this.setupGlobalAdminProperties()));
            this.globalAdminContext = this.globalAdminComputeContext.getGlobalContext();
            this.globalAdminClient = (CloudStackGlobalClient)this.globalAdminContext.getApi();
            this.globalAdminUser = BaseCloudStackClientLiveTest.verifyCurrentUserIsOfType(this.globalAdminContext, Account.Type.ADMIN);
            this.adminClient = (CloudStackClient)this.globalAdminContext.getApi();
        }
        this.injector = Guice.createInjector((Module[])new Module[]{new SshjSshClientModule(), new Log4JLoggingModule()});
        this.sshFactory = (SshClient.Factory)this.injector.getInstance(SshClient.Factory.class);
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), 180L, 1L, 1L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.socketTester);
        this.jobComplete = new RetryablePredicate((Predicate)new JobComplete(this.client), 1200L, 1L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.jobComplete);
        this.adminJobComplete = new RetryablePredicate((Predicate)new JobComplete(this.adminClient), 1200L, 1L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.adminJobComplete);
        this.virtualMachineRunning = new RetryablePredicate((Predicate)new VirtualMachineRunning(this.client), 600L, 5L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.virtualMachineRunning);
        this.adminVirtualMachineRunning = new RetryablePredicate((Predicate)new VirtualMachineRunning(this.adminClient), 600L, 5L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.adminVirtualMachineRunning);
        this.virtualMachineDestroyed = new RetryablePredicate((Predicate)new VirtualMachineDestroyed(this.client), 600L, 5L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.virtualMachineDestroyed);
        this.adminVirtualMachineDestroyed = new RetryablePredicate((Predicate)new VirtualMachineDestroyed(this.adminClient), 600L, 5L, 5L, TimeUnit.SECONDS);
        this.injector.injectMembers(this.adminVirtualMachineDestroyed);
        this.reuseOrAssociate = new ReuseOrAssociateNewPublicIPAddress(this.client, new BlockUntilJobCompletesAndReturnResult(this.client, this.jobComplete));
        this.injector.injectMembers((Object)this.reuseOrAssociate);
    }

    protected static User verifyCurrentUserIsOfType(RestContext<? extends CloudStackClient, ? extends CloudStackAsyncClient> context, Account.Type type) {
        User currentUser;
        Iterable users = Iterables.concat((Iterable)((CloudStackClient)context.getApi()).getAccountClient().listAccounts(new ListAccountsOptions[0]));
        Predicate apiKeyMatches = UserPredicates.apiKeyEquals((String)context.getIdentity());
        try {
            currentUser = (User)Iterables.find((Iterable)users, (Predicate)apiKeyMatches);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("none of the following users match %s: %s", apiKeyMatches, users));
        }
        if (currentUser.getAccountType() != type) {
            Logger.getAnonymousLogger().warning(String.format("Expecting an user with type %s. Got: %s", type.toString(), currentUser.toString()));
        }
        return currentUser;
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.context != null) {
            this.context.close();
        }
    }
}

